/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.sqlite.Codes;
import org.sqlite.DB;
import org.sqlite.Stmt;
import org.sqlite.Unused;

final class RS
extends Unused
implements ResultSet,
ResultSetMetaData,
Codes {
    private final Stmt stmt;
    private final DB db;
    boolean open = false;
    int maxRows;
    String[] cols = null;
    String[] colsMeta = null;
    boolean[][] meta = null;
    private int limitRows;
    private int row = 1;
    private int lastCol;

    RS(Stmt stmt) {
        this.stmt = stmt;
        this.db = stmt.db;
    }

    boolean isOpen() {
        return this.open;
    }

    void checkOpen() throws SQLException {
        if (!this.open) {
            throw new SQLException("ResultSet closed");
        }
    }

    private int checkCol(int n2) throws SQLException {
        if (this.colsMeta == null) {
            throw new IllegalStateException("SQLite JDBC: inconsistent internal state");
        }
        if (n2 < 1 || n2 > this.colsMeta.length) {
            throw new SQLException("column " + n2 + " out of bounds [1," + this.colsMeta.length + "]");
        }
        return --n2;
    }

    private int markCol(int n2) throws SQLException {
        this.checkOpen();
        this.checkCol(n2);
        this.lastCol = n2--;
        return n2;
    }

    private void checkMeta() throws SQLException {
        this.checkCol(1);
        if (this.meta == null) {
            this.meta = this.db.column_metadata(this.stmt.pointer);
        }
    }

    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    public void close() throws SQLException {
        this.cols = null;
        this.colsMeta = null;
        this.meta = null;
        this.open = false;
        this.limitRows = 0;
        this.row = 1;
        this.lastCol = -1;
        if (this.stmt == null) {
            return;
        }
        if (this.stmt != null && this.stmt.pointer != 0L) {
            this.db.reset(this.stmt.pointer);
        }
    }

    public int findColumn(String string) throws SQLException {
        this.checkOpen();
        int n2 = -1;
        for (int i2 = 0; i2 < this.cols.length; ++i2) {
            if (!string.equalsIgnoreCase(this.cols[i2]) && (!this.cols[i2].toUpperCase().endsWith(string.toUpperCase()) || this.cols[i2].charAt(this.cols[i2].length() - string.length()) != '.')) continue;
            if (n2 == -1) {
                n2 = i2;
                continue;
            }
            throw new SQLException("ambiguous column: '" + string + "'");
        }
        if (n2 == -1) {
            throw new SQLException("no such column: '" + string + "'");
        }
        return n2 + 1;
    }

    public boolean next() throws SQLException {
        if (!this.open) {
            return false;
        }
        this.lastCol = -1;
        if (this.row == 1) {
            ++this.row;
            return true;
        }
        if (this.maxRows != 0 && this.row > this.maxRows) {
            return false;
        }
        if (this.limitRows != 0 && this.row >= this.limitRows) {
            return false;
        }
        switch (this.db.step(this.stmt.pointer)) {
            case 101: {
                this.close();
                return false;
            }
            case 100: {
                ++this.row;
                return true;
            }
            case 5: {
                throw new SQLException("database locked");
            }
        }
        this.db.throwex();
        return false;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public int getFetchSize() throws SQLException {
        return this.limitRows;
    }

    public void setFetchSize(int n2) throws SQLException {
        if (0 > n2 || this.maxRows != 0 && n2 > this.maxRows) {
            throw new SQLException("fetch size " + n2 + " out of bounds " + this.maxRows);
        }
        this.limitRows = n2;
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.checkOpen();
        if (n2 != 1000) {
            throw new SQLException("only FETCH_FORWARD direction supported");
        }
    }

    public boolean isAfterLast() throws SQLException {
        return !this.open;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.open && this.row == 1;
    }

    public boolean isFirst() throws SQLException {
        return this.row == 2;
    }

    public boolean isLast() throws SQLException {
        throw new SQLException("function not yet implemented for SQLite");
    }

    protected void finalize() throws SQLException {
        this.close();
    }

    public int getRow() throws SQLException {
        return this.row;
    }

    public boolean wasNull() throws SQLException {
        return this.db.column_type(this.stmt.pointer, this.markCol(this.lastCol)) == 5;
    }

    public boolean getBoolean(int n2) throws SQLException {
        return this.getInt(n2) != 0;
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n2) throws SQLException {
        return (byte)this.getInt(n2);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n2) throws SQLException {
        return this.db.column_blob(this.stmt.pointer, this.markCol(n2));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(int n2) throws SQLException {
        if (this.db.column_type(this.stmt.pointer, this.markCol(n2)) == 5) {
            return null;
        }
        return new Date(this.db.column_long(this.stmt.pointer, this.markCol(n2)));
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        if (this.db.column_type(this.stmt.pointer, this.markCol(n2)) == 5) {
            return null;
        }
        if (calendar == null) {
            return this.getDate(n2);
        }
        calendar.setTimeInMillis(this.db.column_long(this.stmt.pointer, this.markCol(n2)));
        return new Date(calendar.getTime().getTime());
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string), Calendar.getInstance());
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n2) throws SQLException {
        if (this.db.column_type(this.stmt.pointer, this.markCol(n2)) == 5) {
            return 0.0;
        }
        return this.db.column_double(this.stmt.pointer, this.markCol(n2));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n2) throws SQLException {
        if (this.db.column_type(this.stmt.pointer, this.markCol(n2)) == 5) {
            return 0.0f;
        }
        return (float)this.db.column_double(this.stmt.pointer, this.markCol(n2));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n2) throws SQLException {
        return this.db.column_int(this.stmt.pointer, this.markCol(n2));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n2) throws SQLException {
        return this.db.column_long(this.stmt.pointer, this.markCol(n2));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public short getShort(int n2) throws SQLException {
        return (short)this.getInt(n2);
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n2) throws SQLException {
        return this.db.column_text(this.stmt.pointer, this.markCol(n2));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n2) throws SQLException {
        if (this.db.column_type(this.stmt.pointer, this.markCol(n2)) == 5) {
            return null;
        }
        return new Time(this.db.column_long(this.stmt.pointer, this.markCol(n2)));
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTime(n2);
        }
        if (this.db.column_type(this.stmt.pointer, this.markCol(n2)) == 5) {
            return null;
        }
        calendar.setTimeInMillis(this.db.column_long(this.stmt.pointer, this.markCol(n2)));
        return new Time(calendar.getTime().getTime());
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        if (this.db.column_type(this.stmt.pointer, this.markCol(n2)) == 5) {
            return null;
        }
        return new Timestamp(this.db.column_long(this.stmt.pointer, this.markCol(n2)));
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTimestamp(n2);
        }
        if (this.db.column_type(this.stmt.pointer, this.markCol(n2)) == 5) {
            return null;
        }
        calendar.setTimeInMillis(this.db.column_long(this.stmt.pointer, this.markCol(n2)));
        return new Timestamp(calendar.getTime().getTime());
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Object getObject(int n2) throws SQLException {
        switch (this.db.column_type(this.stmt.pointer, this.checkCol(n2))) {
            case 1: {
                long l2 = this.getLong(n2);
                if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
                    return new Long(l2);
                }
                return new Integer((int)l2);
            }
            case 2: {
                return new Double(this.getDouble(n2));
            }
            case 4: {
                return this.getBytes(n2);
            }
            case 5: {
                return null;
            }
        }
        return this.getString(n2);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Statement getStatement() {
        return this.stmt;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public String getCatalogName(int n2) throws SQLException {
        return this.db.column_table_name(this.stmt.pointer, this.checkCol(n2));
    }

    public String getColumnClassName(int n2) throws SQLException {
        this.checkCol(n2);
        return "java.lang.Object";
    }

    public int getColumnCount() throws SQLException {
        this.checkCol(1);
        return this.colsMeta.length;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        return Integer.MAX_VALUE;
    }

    public String getColumnLabel(int n2) throws SQLException {
        return this.getColumnName(n2);
    }

    public String getColumnName(int n2) throws SQLException {
        return this.db.column_name(this.stmt.pointer, this.checkCol(n2));
    }

    public int getColumnType(int n2) throws SQLException {
        switch (this.db.column_type(this.stmt.pointer, this.checkCol(n2))) {
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 4: {
                return 2004;
            }
            case 5: {
                return 0;
            }
        }
        return 12;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        switch (this.db.column_type(this.stmt.pointer, this.checkCol(n2))) {
            case 1: {
                return "integer";
            }
            case 2: {
                return "float";
            }
            case 4: {
                return "blob";
            }
            case 5: {
                return "null";
            }
        }
        return "text";
    }

    public int getPrecision(int n2) throws SQLException {
        return 0;
    }

    public int getScale(int n2) throws SQLException {
        return 0;
    }

    public String getSchemaName(int n2) throws SQLException {
        return "";
    }

    public String getTableName(int n2) throws SQLException {
        return this.db.column_table_name(this.stmt.pointer, this.checkCol(n2));
    }

    public int isNullable(int n2) throws SQLException {
        this.checkMeta();
        return this.meta[this.checkCol(n2)][1] ? 0 : 1;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        this.checkMeta();
        return this.meta[this.checkCol(n2)][2];
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        return true;
    }

    public boolean isCurrency(int n2) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        return true;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n2) throws SQLException {
        return true;
    }

    public boolean isSigned(int n2) throws SQLException {
        return false;
    }

    public boolean isWritable(int n2) throws SQLException {
        return true;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }
}

