/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseSplitPaneDivider;
import com.jtattoo.plaf.texture.TextureSplitPaneUI;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.UIManager;

public class TextureSplitPaneDivider
extends BaseSplitPaneDivider {
    public TextureSplitPaneDivider(TextureSplitPaneUI ui) {
        super(ui);
    }

    public void paint(Graphics g2) {
        TextureUtils.fillComponent(g2, this, TextureUtils.getTextureType(this.splitPane));
        Graphics2D g2D = (Graphics2D)g2;
        Composite savedComposite = g2D.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
        g2D.setComposite(alpha);
        int width = this.getSize().width;
        int height = this.getSize().height;
        int dx = 0;
        int dy = 0;
        if (width % 2 == 1) {
            dx = 1;
        }
        if (height % 2 == 1) {
            dy = 1;
        }
        Icon horBumps = null;
        Icon verBumps = null;
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            AbstractLookAndFeel laf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
            horBumps = laf.getIconFactory().getSplitterHorBumpIcon();
            verBumps = laf.getIconFactory().getSplitterVerBumpIcon();
        }
        if (this.orientation == 1) {
            if (horBumps != null && width > horBumps.getIconWidth()) {
                if (this.splitPane.isOneTouchExpandable() && this.centerOneTouchButtons) {
                    int centerY = height / 2;
                    int x2 = (width - horBumps.getIconWidth()) / 2 + dx;
                    int y2 = centerY - horBumps.getIconHeight() - 40;
                    horBumps.paintIcon(this, g2, x2, y2);
                    y2 = centerY + 40;
                    horBumps.paintIcon(this, g2, x2, y2);
                } else {
                    int x3 = (width - horBumps.getIconWidth()) / 2 + dx;
                    int y3 = (height - horBumps.getIconHeight()) / 2;
                    horBumps.paintIcon(this, g2, x3, y3);
                }
            }
        } else if (verBumps != null && height > verBumps.getIconHeight()) {
            if (this.splitPane.isOneTouchExpandable() && this.centerOneTouchButtons) {
                int centerX = width / 2;
                int x4 = centerX - verBumps.getIconWidth() - 40;
                int y4 = (height - verBumps.getIconHeight()) / 2 + dy;
                verBumps.paintIcon(this, g2, x4, y4);
                x4 = centerX + 40;
                verBumps.paintIcon(this, g2, x4, y4);
            } else {
                int x5 = (width - verBumps.getIconWidth()) / 2;
                int y5 = (height - verBumps.getIconHeight()) / 2 + dy;
                verBumps.paintIcon(this, g2, x5, y5);
            }
        }
        g2D.setComposite(savedComposite);
        this.paintComponents(g2);
    }
}

