/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseMenuUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;

public class TextureMenuUI
extends BaseMenuUI {
    public TextureMenuUI() {
        this.paintRolloverBorder = false;
    }

    public static ComponentUI createUI(JComponent c2) {
        return new TextureMenuUI();
    }

    protected void paintBackground(Graphics g2, JComponent c2, int x2, int y2, int w2, int h2) {
        JMenuItem b2 = (JMenuItem)c2;
        ButtonModel model = b2.getModel();
        if (c2.getParent() instanceof JMenuBar) {
            if (model.isRollover() || model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                TextureUtils.fillComponent(g2, c2, 4);
            }
        } else if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
            TextureUtils.fillComponent(g2, c2, 4);
        } else {
            TextureUtils.fillComponent(g2, c2, 7);
        }
    }

    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text) {
        if (!AbstractLookAndFeel.getTheme().isDarkTexture()) {
            super.paintText(g2, menuItem, textRect, text);
            return;
        }
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            g2.setColor(Color.black);
            JTattooUtilities.drawStringUnderlineCharAt(menuItem, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getDisabledForegroundColor(), 40.0));
        } else {
            g2.setColor(AbstractLookAndFeel.getMenuForegroundColor());
            if (menuItem.getParent() instanceof JMenuBar) {
                if (model.isRollover() || model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                    g2.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
                }
            } else if (menuItem.isArmed() || menuItem.isSelected()) {
                g2.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
            } else {
                g2.setColor(Color.black);
                JTattooUtilities.drawStringUnderlineCharAt(menuItem, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
                g2.setColor(AbstractLookAndFeel.getMenuForegroundColor());
            }
        }
        JTattooUtilities.drawStringUnderlineCharAt(menuItem, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }
}

