/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TextureBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return TextureBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new MenuItemBorder();
        }
        return menuItemBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder();
        }
        return popupMenuBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getToolBarBorder() {
        if (toolBarBorder == null) {
            toolBarBorder = new ToolBarBorder();
        }
        return toolBarBorder;
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        private static final LazyImageIcon HOR_RUBBER_ICON = new LazyImageIcon("texture/icons/HorRubber.gif");
        private static final LazyImageIcon VER_RUBBER_ICON = new LazyImageIcon("texture/icons/VerRubber.gif");

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            if (((JToolBar)c2).isFloatable()) {
                if (((JToolBar)c2).getOrientation() == 0) {
                    int x1 = 4;
                    int y1 = (h2 - HOR_RUBBER_ICON.getIconHeight()) / 2;
                    HOR_RUBBER_ICON.paintIcon(c2, g2, x1, y1);
                } else {
                    int x1 = (w2 - VER_RUBBER_ICON.getIconWidth()) / 2 + 2;
                    int y1 = 4;
                    VER_RUBBER_ICON.paintIcon(c2, g2, x1, y1);
                }
            }
        }

        public Insets getBorderInsets(Component c2) {
            Insets margin;
            Insets insets = new Insets(2, 2, 2, 2);
            if (((JToolBar)c2).isFloatable()) {
                if (((JToolBar)c2).getOrientation() == 0) {
                    if (JTattooUtilities.isLeftToRight(c2)) {
                        insets.left = 15;
                    } else {
                        insets.right = 15;
                    }
                } else {
                    insets.top = 15;
                }
            }
            if ((margin = ((JToolBar)c2).getMargin()) != null) {
                insets.left += margin.left;
                insets.top += margin.top;
                insets.right += margin.right;
                insets.bottom += margin.bottom;
            }
            return insets;
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            Insets insets = this.getBorderInsets(c2);
            borderInsets.left = insets.left;
            borderInsets.top = insets.top;
            borderInsets.right = insets.right;
            borderInsets.bottom = insets.bottom;
            return borderInsets;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        private static final Color FRAME_BORDER_COLOR = new Color(128, 128, 128);
        private static final Color[] FRAME_COLORS = new Color[]{new Color(144, 144, 144), new Color(180, 180, 180), new Color(216, 216, 216), new Color(236, 236, 236), new Color(164, 164, 164), new Color(196, 196, 196), new Color(184, 184, 184), new Color(172, 172, 172)};

        public Insets getBorderInsets(Component c2) {
            if (this.isResizable(c2)) {
                return new Insets(5, 8, 6, 8);
            }
            return new Insets(this.paletteInsets.top, this.paletteInsets.left, this.paletteInsets.bottom, this.paletteInsets.right);
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            int i2;
            JRootPane jp;
            boolean isJFrameBorder = false;
            if (c2 instanceof JRootPane && (jp = (JRootPane)c2).getParent() instanceof JFrame) {
                isJFrameBorder = true;
            }
            Graphics2D g2D = (Graphics2D)g2;
            Composite savedComposite = g2D.getComposite();
            if (!isJFrameBorder) {
                TextureUtils.fillComponent(g2, c2, 1, 1, w2 - 1, h2 - 1, 0);
                g2.setColor(AbstractLookAndFeel.getTheme().getWindowBorderColor());
                g2.drawRect(0, 0, w2 - 1, h2 - 1);
            } else {
                Insets bi = this.getBorderInsets(c2);
                ColorUIResource frameColor = AbstractLookAndFeel.getTheme().getWindowBorderColor();
                g2.setColor(frameColor);
                g2.drawLine(x2, y2, w2, y2);
                TextureUtils.fillComponent(g2, c2, 1, 1, w2, bi.top - 1, 0);
                g2.setColor(frameColor);
                g2.drawLine(x2, y2 + h2 - 1, w2, y2 + h2 - 1);
                TextureUtils.fillComponent(g2, c2, 1, h2 - bi.bottom, w2, bi.bottom - 1, 0);
                g2.setColor(FRAME_BORDER_COLOR);
                g2.drawLine(x2, y2, x2, y2 + h2);
                g2.drawLine(x2 + w2 - 1, y2, x2 + w2 - 1, y2 + h2);
                for (i2 = 1; i2 < FRAME_COLORS.length; ++i2) {
                    g2D.setColor(FRAME_COLORS[i2]);
                    g2D.drawLine(i2, 0, i2, h2);
                }
                for (i2 = 0; i2 < FRAME_COLORS.length - 1; ++i2) {
                    g2D.setColor(FRAME_COLORS[i2]);
                    g2D.drawLine(w2 - 8 + i2, 0, w2 - 8 + i2, h2);
                }
                g2.setColor(ColorHelper.brighter(FRAME_BORDER_COLOR, 20.0));
                g2.drawLine(x2, y2, x2 + bi.left - 1, y2);
                g2.drawLine(x2 + w2 - bi.right, y2, x2 + w2 - 1, y2);
            }
            if (this.isResizable(c2)) {
                float alphaValue = 0.4f;
                float alphaDelta = 0.1f;
                g2D.setColor(Color.white);
                if (!AbstractLookAndFeel.getTheme().isDarkTexture()) {
                    alphaValue = 0.8f;
                    alphaDelta = 0.2f;
                }
                for (i2 = 1; i2 < 5; ++i2) {
                    g2D.setComposite(AlphaComposite.getInstance(3, alphaValue));
                    g2D.drawLine(1, i2, w2 - 2, i2);
                    alphaValue -= alphaDelta;
                }
                alphaValue = 0.3f;
                alphaDelta = 0.05f;
                g2D.setColor(Color.black);
                if (!AbstractLookAndFeel.getTheme().isDarkTexture()) {
                    alphaValue = 0.14f;
                    alphaDelta = 0.02f;
                }
                for (i2 = 1; i2 < 6; ++i2) {
                    g2D.setComposite(AlphaComposite.getInstance(3, alphaValue));
                    g2D.drawLine(1, h2 - i2, w2 - 2, h2 - i2);
                    alphaValue -= alphaDelta;
                }
            }
            g2D.setComposite(savedComposite);
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            JMenuItem b2 = (JMenuItem)c2;
            ButtonModel model = b2.getModel();
            ColorUIResource frameColor = AbstractLookAndFeel.getFrameColor();
            if (c2.getParent() instanceof JMenuBar) {
                if (model.isArmed() || model.isSelected()) {
                    g2.setColor(frameColor);
                    g2.drawLine(x2, y2, x2 + w2 - 1, y2);
                    g2.drawLine(x2, y2, x2, y2 + h2 - 1);
                    g2.drawLine(x2 + w2 - 1, y2 + 1, x2 + w2 - 1, y2 + h2 - 1);
                }
            } else if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                g2.setColor(frameColor);
                g2.drawLine(x2, y2, x2 + w2 - 1, y2);
                g2.drawLine(x2, y2 + h2 - 1, x2 + w2 - 1, y2 + h2 - 1);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(MenuItemBorder.insets.top, MenuItemBorder.insets.left, MenuItemBorder.insets.bottom, MenuItemBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = MenuItemBorder.insets.left;
            borderInsets.top = MenuItemBorder.insets.top;
            borderInsets.right = MenuItemBorder.insets.right;
            borderInsets.bottom = MenuItemBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    public static class PopupMenuBorder
    extends BaseBorders.BasePopupMenuBorder {
        private static final float[] shadowAlpha = new float[]{0.6f, 0.4f, 0.2f, 0.1f};

        public PopupMenuBorder() {
            shadowSize = 4;
            leftLogoInsets = new Insets(1, 18, 1, 1);
            rightLogoInsets = new Insets(1, 1, 1, 18);
            insets = new Insets(1, 1, 1, 1);
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            int dx;
            Graphics2D g2D = (Graphics2D)g2;
            ColorUIResource frameColor = AbstractLookAndFeel.getFrameColor();
            g2.setColor(frameColor);
            if (JTattooUtilities.isLeftToRight(c2)) {
                dx = this.getBorderInsets((Component)c2).left;
                if (this.hasLogo(c2)) {
                    TextureUtils.fillComponent(g2, c2, x2, y2, dx, h2 - 1 - shadowSize, 4);
                    this.paintLogo(c2, g2, x2, y2, w2, h2);
                }
                g2.setColor(frameColor);
                if (this.isMenuBarPopup(c2)) {
                    g2.drawLine(x2 + dx, y2, x2 + w2 - shadowSize - 1, y2);
                } else {
                    g2.drawLine(x2, y2, x2 + w2 - shadowSize - 1, y2);
                }
                g2.drawLine(x2, y2, x2, y2 + h2 - shadowSize - 1);
                g2.drawLine(x2, y2 + h2 - shadowSize - 1, x2 + w2 - shadowSize - 1, y2 + h2 - shadowSize - 1);
                g2.drawLine(x2 + w2 - shadowSize - 1, y2, x2 + w2 - shadowSize - 1, y2 + h2 - shadowSize - 1);
            } else {
                dx = this.getBorderInsets((Component)c2).right - shadowSize;
                if (this.hasLogo(c2)) {
                    TextureUtils.fillComponent(g2, c2, x2 + w2 - dx - shadowSize, y2, dx - 1, h2 - 1 - shadowSize, 4);
                    this.paintLogo(c2, g2, x2, y2, w2, h2);
                }
                g2.setColor(frameColor);
                if (this.isMenuBarPopup(c2)) {
                    g2.drawLine(x2, y2, x2 + w2 - dx - shadowSize - 1, y2);
                } else {
                    g2.drawLine(x2, y2, x2 + w2 - shadowSize - 1, y2);
                }
                g2.drawLine(x2, y2, x2, y2 + h2 - shadowSize - 1);
                g2.drawLine(x2, y2 + h2 - shadowSize - 1, x2 + w2 - shadowSize - 1, y2 + h2 - shadowSize - 1);
                g2.drawLine(x2 + w2 - shadowSize - 1, y2, x2 + w2 - shadowSize - 1, y2 + h2 - shadowSize - 1);
            }
            Composite savedComposite = g2D.getComposite();
            g2D.setColor(Color.black);
            for (int i2 = 0; i2 < shadowSize; ++i2) {
                AlphaComposite alpha = AlphaComposite.getInstance(3, shadowAlpha[i2]);
                g2D.setComposite(alpha);
                g2.drawLine(x2 + shadowSize, y2 + h2 - shadowSize + i2, x2 + w2 - shadowSize + i2, y2 + h2 - shadowSize + i2);
                g2.drawLine(x2 + w2 - shadowSize + i2, y2 + shadowSize, x2 + w2 - shadowSize + i2, y2 + h2 - shadowSize - 1 + i2);
            }
            g2D.setComposite(savedComposite);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            Color loColor = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 50.0);
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.black);
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.white);
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultColorHi = new Color(220, 230, 245);
        private static final Color defaultColorMed = new Color(212, 224, 243);
        private static final Color defaultColorLo = new Color(200, 215, 240);
        private static final Insets insets = new Insets(3, 4, 3, 4);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            Graphics2D g2D = (Graphics2D)g2;
            AbstractButton b2 = (AbstractButton)c2;
            Color frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b2.hasFocus()) {
                frameColor = AbstractLookAndFeel.getTheme().getFocusFrameColor();
            }
            if (!b2.isEnabled()) {
                frameColor = ColorHelper.brighter(frameColor, 20.0);
            } else if (b2.getModel().isRollover()) {
                frameColor = ColorHelper.darker(frameColor, 20.0);
            }
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite saveComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRoundRect(x2, y2, w2 - 1, h2 - 1, 6, 6);
            g2D.setComposite(saveComposite);
            if (b2.getRootPane() != null && b2.equals(b2.getRootPane().getDefaultButton()) && !b2.hasFocus()) {
                g2D.setColor(ColorHelper.darker(frameColor, 20.0));
                g2D.drawRoundRect(x2, y2, w2 - 1, h2 - 2, 6, 6);
                if (!b2.getModel().isRollover()) {
                    g2D.setColor(defaultColorHi);
                    g2D.drawRoundRect(x2 + 1, y2 + 1, w2 - 3, h2 - 4, 6, 6);
                    g2D.setColor(defaultColorMed);
                    g2D.drawRoundRect(x2 + 2, y2 + 2, w2 - 5, h2 - 6, 6, 6);
                    g2D.setColor(defaultColorLo);
                    g2D.drawLine(x2 + 3, h2 - 3, w2 - 3, h2 - 3);
                    g2D.drawLine(w2 - 2, y2 + 4, w2 - 2, h2 - 4);
                }
            } else {
                g2D.setColor(frameColor);
                g2D.drawRoundRect(x2, y2, w2 - 1, h2 - 2, 6, 6);
                g2D.setColor(ColorHelper.brighter(frameColor, 20.0));
                g2D.drawLine(x2 + 2, y2, w2 - 3, y2);
                g2D.setColor(ColorHelper.darker(frameColor, 10.0));
                g2D.drawLine(x2 + 2, h2 - 2, w2 - 3, h2 - 2);
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

