/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JButton;

public class MintIcons
extends BaseIcons {
    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacIconIcon() : new TitleButtonIcon(0);
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMinIcon() : new TitleButtonIcon(1);
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMaxIcon() : new TitleButtonIcon(2);
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacCloseIcon() : new TitleButtonIcon(3);
        }
        return closeIcon;
    }

    private static class TitleButtonIcon
    implements Icon {
        private static Color closerColorLight = new Color(241, 172, 154);
        private static Color closerColorDark = new Color(224, 56, 2);
        public static final int ICON_ICON_TYP = 0;
        public static final int MIN_ICON_TYP = 1;
        public static final int MAX_ICON_TYP = 2;
        public static final int CLOSE_ICON_TYP = 3;
        private int iconTyp = 0;

        public TitleButtonIcon(int typ) {
            this.iconTyp = typ;
        }

        public int getIconHeight() {
            return 20;
        }

        public int getIconWidth() {
            return 20;
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            int w2 = c2.getWidth();
            int h2 = c2.getHeight();
            JButton b2 = (JButton)c2;
            Graphics2D g2D = (Graphics2D)g2;
            boolean isActive = JTattooUtilities.isActive(b2);
            boolean isPressed = b2.getModel().isPressed();
            boolean isArmed = b2.getModel().isArmed();
            boolean isRollover = b2.getModel().isRollover();
            Color cHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowTitleColorLight(), 40.0);
            Color cLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 10.0);
            if (this.iconTyp == 3) {
                cHi = closerColorLight;
                cLo = closerColorDark;
            }
            Color fcHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 80.0);
            Color fcLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 40.0);
            if (!isActive) {
                cHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight(), 40.0);
                cLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark(), 10.0);
                fcHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight(), 60.0);
                fcLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark(), 10.0);
            }
            if (isPressed && isArmed) {
                Color cTemp = ColorHelper.darker(cLo, 10.0);
                cLo = ColorHelper.darker(cHi, 10.0);
                cHi = cTemp;
            } else if (isRollover) {
                cHi = ColorHelper.brighter(cHi, 30.0);
                cLo = ColorHelper.brighter(cLo, 30.0);
            }
            Shape savedClip = g2.getClip();
            Area area = new Area(new RoundRectangle2D.Double(1.0, 1.0, w2 - 1, h2 - 1, 3.0, 3.0));
            g2D.setClip(area);
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, fcLo, w2, h2, fcHi));
            g2.fillRect(1, 1, w2 - 1, h2 - 1);
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, ColorHelper.brighter(cHi, 80.0), w2, h2, ColorHelper.darker(cLo, 30.0)));
            g2.fillRect(2, 2, w2 - 3, h2 - 3);
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, cHi, w2, h2, cLo));
            g2.fillRect(3, 3, w2 - 5, h2 - 5);
            g2D.setClip(savedClip);
            cHi = Color.white;
            cLo = ColorHelper.darker(cLo, 30.0);
            Icon icon = null;
            if (this.iconTyp == 0) {
                icon = new BaseIcons.IconSymbol(cHi, cLo, null);
            } else if (this.iconTyp == 1) {
                icon = new BaseIcons.MinSymbol(cHi, cLo, null);
            } else if (this.iconTyp == 2) {
                icon = new BaseIcons.MaxSymbol(cHi, cLo, null);
            } else if (this.iconTyp == 3) {
                icon = new BaseIcons.CloseSymbol(cHi, cLo, null);
            }
            if (icon != null) {
                icon.paintIcon(c2, g2, 0, 0);
            }
        }
    }
}

