/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MintButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new MintButtonUI();
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        if (!b2.isContentAreaFilled() || b2.getParent() instanceof JMenuBar) {
            return;
        }
        if (!b2.isBorderPainted() || !(b2.getBorder() instanceof UIResource)) {
            super.paintBackground(g2, b2);
            return;
        }
        if (b2.getWidth() < 32 || b2.getHeight() < 16) {
            ButtonModel model = b2.getModel();
            ColorUIResource color = AbstractLookAndFeel.getTheme().getButtonBackgroundColor();
            if (model.isPressed() && model.isArmed()) {
                color = AbstractLookAndFeel.getTheme().getSelectionBackgroundColor();
            } else if (b2.isRolloverEnabled() && model.isRollover()) {
                color = AbstractLookAndFeel.getTheme().getRolloverColor();
            }
            g2.setColor(color);
            g2.fillRect(0, 0, b2.getWidth(), b2.getHeight());
            JTattooUtilities.draw3DBorder(g2, Color.white, Color.lightGray, 0, 0, b2.getWidth(), b2.getHeight());
            return;
        }
        Graphics2D g2D = (Graphics2D)g2;
        int width = b2.getWidth() - 2;
        int height = b2.getHeight() - 2;
        ButtonModel model = b2.getModel();
        if (model.isPressed() && model.isArmed()) {
            ColorUIResource color = AbstractLookAndFeel.getTheme().getSelectionBackgroundColor();
            g2D.setColor(color);
            g2D.fillRoundRect(0, 0, width, height, height, height);
            g2D.setColor(ColorHelper.darker(color, 40.0));
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawRoundRect(0, 0, width - 1, height - 1, height, height);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            return;
        }
        Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
        if (!model.isEnabled()) {
            colors = AbstractLookAndFeel.getTheme().getDisabledColors();
        } else if (b2.isRolloverEnabled() && model.isRollover()) {
            Color[] src = AbstractLookAndFeel.getTheme().getRolloverColors();
            colors = new Color[src.length];
            System.arraycopy(src, 0, colors, 0, colors.length);
            colors[colors.length - 2] = ColorHelper.darker(colors[colors.length - 2], 15.0);
        }
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = b2.getParent().getBackground();
        g2D.setColor(ColorHelper.darker(color, 6.0));
        g2D.drawRoundRect(2, 2, width - 1, height - 1, height, height);
        g2D.setColor(ColorHelper.darker(color, 18.0));
        g2D.drawRoundRect(1, 1, width - 1, height - 1, height, height);
        int x2 = 0;
        int y2 = 0;
        int w2 = width;
        int h2 = height;
        for (int i2 = colors.length - 1; i2 >= 0; --i2) {
            g2D.setColor(colors[i2]);
            g2D.fillRoundRect(x2, y2, w2, h2, h2, h2);
            --h2;
            --w2;
            if ((i2 + 1) % 4 == 0) {
                ++x2;
                ++y2;
            }
            if (h2 == 0) break;
        }
        g2D.setColor(Color.white);
        g2D.drawRoundRect(1, 1, width - 3, height - 3, height - 2, height - 2);
        g2D.drawRoundRect(1, 1, width - 3, height - 3, height - 2, height - 2);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Graphics2D g2D = (Graphics2D)g2;
        int width = b2.getWidth();
        int height = b2.getHeight();
        if (!(b2.isContentAreaFilled() && (width >= 64 && height >= 16 || b2.getText() != null && b2.getText().length() != 0))) {
            g2.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g2, 4, 3, width - 8, height - 6);
        } else {
            Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(AbstractLookAndFeel.getFocusColor());
            int d2 = height - 6;
            g2D.drawRoundRect(2, 2, width - 7, height - 7, d2, d2);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        }
    }
}

