/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class McWinTitlePane
extends BaseTitlePane {
    public McWinTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public void paintBorder(Graphics g2) {
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getTheme().getWindowBorderColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getTheme().getWindowInactiveBorderColor());
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x2, int y2, String title) {
        x2 += this.paintIcon(g2, x2, y2);
        if (this.isActive()) {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.rootPane, g2, title, x2, y2 + 1);
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, g2, title, x2, y2);
        } else {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowInactiveTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.rootPane, g2, title, x2, y2 + 1);
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, g2, title, x2, y2);
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c2) {
        }

        public void removeLayoutComponent(Component c2) {
        }

        public Dimension preferredLayoutSize(Container c2) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c2) {
            return this.preferredLayoutSize(c2);
        }

        protected int computeHeight() {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(McWinTitlePane.this.getFont());
            return fm.getHeight() + 5;
        }

        public void layoutContainer(Container c2) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c2);
            } else {
                this.layoutDefault(c2);
            }
        }

        public void layoutDefault(Container c2) {
            int buttonHeight;
            boolean leftToRight = McWinTitlePane.this.isLeftToRight();
            int w2 = McWinTitlePane.this.getWidth();
            int h2 = McWinTitlePane.this.getHeight();
            int spacing = McWinTitlePane.this.getHorSpacing();
            int buttonWidth = buttonHeight = h2 - McWinTitlePane.this.getVerSpacing() - 1;
            int x2 = leftToRight ? spacing : w2 - buttonWidth - spacing;
            int y2 = Math.max(0, (h2 - buttonHeight) / 2 - 1);
            int cpx = 0;
            int cpy = 0;
            int cpw = McWinTitlePane.this.getWidth();
            int cph = McWinTitlePane.this.getHeight();
            if (McWinTitlePane.this.menuBar != null) {
                int mw = ((McWinTitlePane)McWinTitlePane.this).menuBar.getPreferredSize().width;
                int mh = ((McWinTitlePane)McWinTitlePane.this).menuBar.getPreferredSize().height;
                if (leftToRight) {
                    cpx = 4 + mw;
                    McWinTitlePane.this.menuBar.setBounds(2, (h2 - mh) / 2, mw, mh);
                } else {
                    McWinTitlePane.this.menuBar.setBounds(McWinTitlePane.this.getWidth() - mw, (h2 - mh) / 2, mw, mh);
                }
                cpw -= 4 + mw;
            }
            int n2 = x2 = leftToRight ? w2 - spacing : 0;
            if (McWinTitlePane.this.closeButton != null) {
                McWinTitlePane.this.closeButton.setBounds(x2 += leftToRight ? -buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            if (McWinTitlePane.this.maxButton != null && McWinTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                McWinTitlePane.this.maxButton.setBounds(x2 += leftToRight ? -spacing - buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            if (McWinTitlePane.this.iconifyButton != null && McWinTitlePane.this.iconifyButton.getParent() != null) {
                McWinTitlePane.this.iconifyButton.setBounds(x2 += leftToRight ? -spacing - buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            McWinTitlePane.this.buttonsWidth = leftToRight ? w2 - x2 : x2;
            if (McWinTitlePane.this.customTitlePanel != null) {
                if (!leftToRight) {
                    cpx += McWinTitlePane.this.buttonsWidth;
                }
                cpw -= McWinTitlePane.this.buttonsWidth;
                Graphics g2 = McWinTitlePane.this.getGraphics();
                if (g2 != null) {
                    FontMetrics fm = g2.getFontMetrics();
                    int tw = SwingUtilities.computeStringWidth(fm, JTattooUtilities.getClippedText(McWinTitlePane.this.getTitle(), fm, cpw));
                    if (leftToRight) {
                        cpx += tw;
                    }
                    cpw -= tw;
                }
                McWinTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
            }
        }

        private void layoutMacStyle(Container c2) {
            int buttonHeight;
            int spacing = McWinTitlePane.this.getHorSpacing();
            int h2 = McWinTitlePane.this.getHeight();
            int buttonWidth = buttonHeight = h2 - McWinTitlePane.this.getVerSpacing();
            int x2 = 0;
            int y2 = 0;
            if (McWinTitlePane.this.closeButton != null) {
                McWinTitlePane.this.closeButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            if (McWinTitlePane.this.iconifyButton != null && McWinTitlePane.this.iconifyButton.getParent() != null) {
                McWinTitlePane.this.iconifyButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            if (McWinTitlePane.this.maxButton != null && McWinTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                McWinTitlePane.this.maxButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            McWinTitlePane.this.buttonsWidth = x2;
            if (McWinTitlePane.this.customTitlePanel != null) {
                int cpx = McWinTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((McWinTitlePane)McWinTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h2;
                McWinTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                McWinTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }
}

