/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class McWinInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public McWinInternalFrameTitlePane(JInternalFrame f2) {
        super(f2);
    }

    protected LayoutManager createLayout() {
        return new MyTitlePaneLayout();
    }

    public void paintBorder(Graphics g2) {
        if (JTattooUtilities.isActive(this)) {
            g2.setColor(AbstractLookAndFeel.getWindowBorderColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x2, int y2, String title) {
        if (this.isMacStyleWindowDecoration()) {
            x2 += this.paintIcon(g2, x2, y2) + 5;
        }
        if (this.isActive()) {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.frame, g2, title, x2, y2 - 1);
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, g2, title, x2, y2 - 2);
        } else {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowInactiveTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.frame, g2, title, x2, y2 - 1);
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, g2, title, x2, y2 - 2);
        }
    }

    class MyTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        MyTitlePaneLayout() {
            super(McWinInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String name, Component c2) {
        }

        public void removeLayoutComponent(Component c2) {
        }

        public Dimension preferredLayoutSize(Container c2) {
            return this.minimumLayoutSize(c2);
        }

        public Dimension minimumLayoutSize(Container c2) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (McWinInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (McWinInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (McWinInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (McWinInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (McWinInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (McWinInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = McWinInternalFrameTitlePane.this.getFontMetrics(McWinInternalFrameTitlePane.this.getFont());
            String frameTitle = McWinInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n2 = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(McWinInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = McWinInternalFrameTitlePane.this.paletteTitleHeight;
            if (!McWinInternalFrameTitlePane.this.isPalette) {
                int fontHeight = fm.getHeight() + 5;
                Icon icon = McWinInternalFrameTitlePane.this.isMacStyleWindowDecoration() ? null : McWinInternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = Math.min(icon.getIconHeight(), 18);
                }
                height = Math.max(fontHeight, iconHeight += 5);
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container c2) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c2);
            } else {
                this.layoutDefault(c2);
            }
        }

        public void layoutDefault(Container c2) {
            int buttonHeight;
            boolean leftToRight = JTattooUtilities.isLeftToRight(McWinInternalFrameTitlePane.this.frame);
            int spacing = McWinInternalFrameTitlePane.this.getHorSpacing();
            int w2 = McWinInternalFrameTitlePane.this.getWidth();
            int h2 = McWinInternalFrameTitlePane.this.getHeight();
            int buttonWidth = buttonHeight = h2 - McWinInternalFrameTitlePane.this.getVerSpacing() - 1;
            int x2 = leftToRight ? w2 - spacing : 0;
            int y2 = Math.max(0, (h2 - buttonHeight) / 2 - 1);
            if (McWinInternalFrameTitlePane.this.frame.isClosable()) {
                McWinInternalFrameTitlePane.this.closeButton.setBounds(x2 += leftToRight ? -buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            if (McWinInternalFrameTitlePane.this.frame.isMaximizable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.maxButton.setBounds(x2 += leftToRight ? -spacing - buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            if (McWinInternalFrameTitlePane.this.frame.isIconifiable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.iconButton.setBounds(x2 += leftToRight ? -spacing - buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            McWinInternalFrameTitlePane.this.buttonsWidth = leftToRight ? w2 - x2 : x2;
            if (McWinInternalFrameTitlePane.this.customTitlePanel != null) {
                int cpx = 0;
                int cpy = 0;
                int cpw = w2;
                int cph = h2;
                Icon icon = McWinInternalFrameTitlePane.this.frame.getFrameIcon();
                cpx = icon != null ? icon.getIconWidth() + 10 : 5;
                cpw -= cpx;
                if (!leftToRight) {
                    cpx += McWinInternalFrameTitlePane.this.buttonsWidth;
                }
                cpw -= McWinInternalFrameTitlePane.this.buttonsWidth;
                Graphics g2 = McWinInternalFrameTitlePane.this.getGraphics();
                if (g2 != null) {
                    FontMetrics fm = g2.getFontMetrics();
                    int tw = SwingUtilities.computeStringWidth(fm, JTattooUtilities.getClippedText(McWinInternalFrameTitlePane.this.frame.getTitle(), fm, cpw));
                    if (leftToRight) {
                        cpx += tw;
                    }
                    cpw -= tw;
                }
                McWinInternalFrameTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
            }
        }

        private void layoutMacStyle(Container c2) {
            int buttonHeight;
            int spacing = McWinInternalFrameTitlePane.this.getHorSpacing();
            int h2 = McWinInternalFrameTitlePane.this.getHeight();
            int buttonWidth = buttonHeight = h2 - McWinInternalFrameTitlePane.this.getVerSpacing();
            int x2 = 0;
            int y2 = 0;
            if (McWinInternalFrameTitlePane.this.frame.isClosable()) {
                McWinInternalFrameTitlePane.this.closeButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            if (McWinInternalFrameTitlePane.this.frame.isIconifiable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.iconButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            if (McWinInternalFrameTitlePane.this.frame.isMaximizable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.maxButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            McWinInternalFrameTitlePane.this.buttonsWidth = x2;
            if (McWinInternalFrameTitlePane.this.customTitlePanel != null) {
                int cpx = McWinInternalFrameTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((McWinInternalFrameTitlePane)McWinInternalFrameTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h2;
                McWinInternalFrameTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                McWinInternalFrameTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }
}

