/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class McWinBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return McWinBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getTabbedPaneBorder() {
        return null;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            boolean active = this.isActive(c2);
            boolean resizable = this.isResizable(c2);
            int th = this.getTitleHeight(c2);
            ColorUIResource frameColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowInactiveTitleColorLight();
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveTitleColorDark();
            if (active) {
                frameColor = AbstractLookAndFeel.getWindowBorderColor();
                titleColor = AbstractLookAndFeel.getWindowTitleColorLight();
                borderColor = AbstractLookAndFeel.getWindowTitleColorDark();
            }
            if (!resizable) {
                Insets borderInsets = this.getBorderInsets(c2);
                g2.setColor(frameColor);
                g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                if (active) {
                    g2.setColor(AbstractLookAndFeel.getWindowTitleColorDark());
                } else {
                    g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleColorDark());
                }
                for (int i2 = 1; i2 < borderInsets.left; ++i2) {
                    g2.drawRect(i2, i2, w2 - 2 * i2 - 1, h2 - 2 * i2 - 1);
                }
                g2.setColor(ColorHelper.brighter(frameColor, 20.0));
                g2.drawLine(borderInsets.left - 1, y2 + th + borderInsets.top, borderInsets.left - 1, y2 + h2 - borderInsets.bottom);
                g2.drawLine(w2 - borderInsets.right, y2 + th + borderInsets.top, w2 - borderInsets.right, y2 + h2 - borderInsets.bottom);
                g2.drawLine(borderInsets.left - 1, y2 + h2 - borderInsets.bottom, w2 - borderInsets.right, y2 + h2 - borderInsets.bottom);
                return;
            }
            g2.setColor(titleColor);
            g2.fillRect(x2, y2 + 1, w2, 4);
            g2.setColor(borderColor);
            g2.fillRect(x2 + 1, y2 + h2 - 5, w2 - 2, 4);
            if (active) {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w2 - 5, 5, 5, th + 1);
            } else {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w2 - 5, 5, 5, th + 1);
            }
            g2.setColor(borderColor);
            g2.fillRect(1, this.insets.top + th + 1, 4, h2 - th - 5);
            g2.fillRect(w2 - 5, this.insets.top + th + 1, 4, h2 - th - 5);
            g2.setColor(ColorHelper.darker(frameColor, 10.0));
            g2.drawRect(x2, y2, w2 - 1, h2 - 1);
            g2.setColor(frameColor);
            g2.drawLine(x2 + 5 - 1, y2 + 5 + th, x2 + 5 - 1, y2 + h2 - 5);
            g2.drawLine(x2 + w2 - 5, y2 + 5 + th, x2 + w2 - 5, y2 + h2 - 5);
            g2.drawLine(x2 + 5 - 1, y2 + h2 - 5, x2 + w2 - 5, y2 + h2 - 5);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            Color frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0);
            if (model.isPressed() && model.isArmed() || model.isSelected()) {
                frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 20.0);
            } else if (model.isRollover()) {
                frameColor = AbstractLookAndFeel.getTheme().getRolloverColor();
            }
            g2.setColor(frameColor);
            g2.drawRect(x2, y2, w2 - 2, h2 - 1);
            g2.setColor(AbstractLookAndFeel.getTheme().getToolbarBackgroundColor());
            g2.drawLine(w2 - 1, 0, w2 - 1, h2 - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.top = 1;
            borderInsets.left = 1;
            borderInsets.bottom = 1;
            borderInsets.right = 1;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
        }

        public Insets getBorderInsets(Component c2) {
            if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
                return new Insets(3, 4, 3, 4);
            }
            return new Insets(2, 12, 2, 12);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            Insets insets = this.getBorderInsets(c2);
            borderInsets.left = insets.left;
            borderInsets.top = insets.top;
            borderInsets.right = insets.right;
            borderInsets.bottom = insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

