/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Graphics;
import javax.swing.JRootPane;

public class LunaTitlePane
extends BaseTitlePane {
    public LunaTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    protected int getHorSpacing() {
        return 2;
    }

    protected int getVerSpacing() {
        return 5;
    }

    protected boolean centerButtons() {
        return false;
    }

    public void paintBorder(Graphics g2) {
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
        } else {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0));
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x2, int y2, String title) {
        x2 += this.paintIcon(g2, x2, y2);
        if (this.isActive()) {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowBorderColor(), 10.0));
            JTattooUtilities.drawString(this.rootPane, g2, title, x2 - 1, y2 - 2);
            g2.setColor(ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowBorderColor(), 25.0));
            JTattooUtilities.drawString(this.rootPane, g2, title, x2 + 1, y2);
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.rootPane, g2, title, x2, y2 - 1);
    }
}

