/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class LunaButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new LunaButtonUI();
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        int w2 = b2.getWidth();
        int h2 = b2.getHeight();
        Graphics2D g2D = (Graphics2D)g2;
        Shape savedClip = g2.getClip();
        if (b2.getBorder() != null && b2.isBorderPainted() && b2.getBorder() instanceof UIResource) {
            Area clipArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, w2 - 1, h2 - 1, 6.0, 6.0));
            clipArea.intersect(new Area(savedClip));
            g2D.setClip(clipArea);
        }
        super.paintBackground(g2, b2);
        if (b2.isContentAreaFilled() && b2.isRolloverEnabled() && b2.getModel().isRollover() && b2.getBorder() != null && b2.isBorderPainted()) {
            g2.setColor(AbstractLookAndFeel.getTheme().getFocusColor());
            Insets ins = b2.getBorder().getBorderInsets(b2);
            if (ins.top == 0 && ins.left == 1) {
                g2.drawRect(1, 0, w2 - 2, h2 - 1);
                g2.drawRect(2, 1, w2 - 4, h2 - 3);
            } else {
                g2.drawRect(1, 1, w2 - 4, h2 - 4);
                g2.drawRect(2, 2, w2 - 6, h2 - 6);
            }
        }
        g2D.setClip(savedClip);
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g2.setColor(Color.black);
        BasicGraphicsUtils.drawDashedRect(g2, 3, 3, b2.getWidth() - 6, b2.getHeight() - 6);
    }
}

