/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import com.jtattoo.plaf.LazyMenuArrowImageIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class HiFiIcons
extends BaseIcons {
    public static Icon getIconIcon() {
        if (iconIcon == null) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                iconIcon = new BaseIcons.MacIconIcon();
            } else {
                ColorUIResource iconColor = AbstractLookAndFeel.getTheme().getWindowIconColor();
                ColorUIResource iconShadowColor = AbstractLookAndFeel.getTheme().getWindowIconShadowColor();
                ColorUIResource iconRolloverColor = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
                iconIcon = new BaseIcons.IconSymbol(iconColor, iconShadowColor, iconRolloverColor, new Insets(-1, -1, 0, 0));
            }
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                minIcon = new BaseIcons.MacMinIcon();
            } else {
                ColorUIResource iconColor = AbstractLookAndFeel.getTheme().getWindowIconColor();
                ColorUIResource iconShadowColor = AbstractLookAndFeel.getTheme().getWindowIconShadowColor();
                ColorUIResource iconRolloverColor = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
                minIcon = new BaseIcons.MinSymbol(iconColor, iconShadowColor, iconRolloverColor, new Insets(-1, -1, 0, 0));
            }
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                maxIcon = new BaseIcons.MacMaxIcon();
            } else {
                ColorUIResource iconColor = AbstractLookAndFeel.getTheme().getWindowIconColor();
                ColorUIResource iconShadowColor = AbstractLookAndFeel.getTheme().getWindowIconShadowColor();
                ColorUIResource iconRolloverColor = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
                maxIcon = new BaseIcons.MaxSymbol(iconColor, iconShadowColor, iconRolloverColor, new Insets(-1, -1, 0, 0));
            }
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                closeIcon = new BaseIcons.MacCloseIcon();
            } else {
                ColorUIResource iconColor = AbstractLookAndFeel.getTheme().getWindowIconColor();
                ColorUIResource iconShadowColor = AbstractLookAndFeel.getTheme().getWindowIconShadowColor();
                ColorUIResource iconRolloverColor = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
                closeIcon = new BaseIcons.CloseSymbol(iconColor, iconShadowColor, iconRolloverColor, new Insets(-1, -1, 0, 0));
            }
        }
        return closeIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getTreeControlIcon(boolean isCollapsed) {
        if (isCollapsed) {
            if (treeClosedIcon == null) {
                treeClosedIcon = new LazyImageIcon("hifi/icons/TreeClosedButton.gif");
            }
            return treeClosedIcon;
        }
        if (treeOpenIcon == null) {
            treeOpenIcon = new LazyImageIcon("hifi/icons/TreeOpenButton.gif");
        }
        return treeOpenIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new LazyMenuArrowImageIcon("hifi/icons/RightArrow.gif", "hifi/icons/LeftArrow.gif");
        }
        return menuArrowIcon;
    }

    public static Icon getComboBoxIcon() {
        return HiFiIcons.getDownArrowIcon();
    }

    public static Icon getSplitterUpArrowIcon() {
        if (splitterUpArrowIcon == null) {
            splitterUpArrowIcon = new LazyImageIcon("hifi/icons/SplitterUpArrow.gif");
        }
        return splitterUpArrowIcon;
    }

    public static Icon getSplitterDownArrowIcon() {
        if (splitterDownArrowIcon == null) {
            splitterDownArrowIcon = new LazyImageIcon("hifi/icons/SplitterDownArrow.gif");
        }
        return splitterDownArrowIcon;
    }

    public static Icon getSplitterLeftArrowIcon() {
        if (splitterLeftArrowIcon == null) {
            splitterLeftArrowIcon = new LazyImageIcon("hifi/icons/SplitterLeftArrow.gif");
        }
        return splitterLeftArrowIcon;
    }

    public static Icon getSplitterRightArrowIcon() {
        if (splitterRightArrowIcon == null) {
            splitterRightArrowIcon = new LazyImageIcon("hifi/icons/SplitterRightArrow.gif");
        }
        return splitterRightArrowIcon;
    }

    public static Icon getSplitterHorBumpIcon() {
        if (splitterHorBumpIcon == null) {
            splitterHorBumpIcon = new LazyImageIcon("hifi/icons/SplitterHorBumps.gif");
        }
        return splitterHorBumpIcon;
    }

    public static Icon getSplitterVerBumpIcon() {
        if (splitterVerBumpIcon == null) {
            splitterVerBumpIcon = new LazyImageIcon("hifi/icons/SplitterVerBumps.gif");
        }
        return splitterVerBumpIcon;
    }

    public static Icon getThumbHorIcon() {
        if (thumbHorIcon == null) {
            thumbHorIcon = new LazyImageIcon("hifi/icons/thumb_hor.gif");
        }
        return thumbHorIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbVerIcon == null) {
            thumbVerIcon = new LazyImageIcon("hifi/icons/thumb_ver.gif");
        }
        return thumbVerIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = new LazyImageIcon("hifi/icons/thumb_hor_rollover.gif");
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = new LazyImageIcon("hifi/icons/thumb_ver_rollover.gif");
        }
        return thumbVerIconRollover;
    }

    public static Icon getUpArrowIcon() {
        if (upArrowIcon == null) {
            upArrowIcon = new LazyImageIcon("hifi/icons/UpArrow.gif");
        }
        return upArrowIcon;
    }

    public static Icon getDownArrowIcon() {
        if (downArrowIcon == null) {
            downArrowIcon = new LazyImageIcon("hifi/icons/DownArrow.gif");
        }
        return downArrowIcon;
    }

    public static Icon getLeftArrowIcon() {
        if (leftArrowIcon == null) {
            leftArrowIcon = new LazyImageIcon("hifi/icons/LeftArrow.gif");
        }
        return leftArrowIcon;
    }

    public static Icon getRightArrowIcon() {
        if (rightArrowIcon == null) {
            rightArrowIcon = new LazyImageIcon("hifi/icons/RightArrow.gif");
        }
        return rightArrowIcon;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static Icon radioIcon = new LazyImageIcon("hifi/icons/RadioSymbol.gif");
        private static Icon baseRadioIcon = new LazyImageIcon("icons/RadioSymbol.gif");
        private final int WIDTH = 16;
        private final int HEIGHT = 16;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            if (!JTattooUtilities.isLeftToRight(c2)) {
                x2 += 4;
            }
            Graphics2D g2D = (Graphics2D)g2;
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            boolean isRollover = button.isRolloverEnabled() && model.isRollover();
            Color[] colors = null;
            colors = button.isEnabled() ? (model.isPressed() ? AbstractLookAndFeel.getTheme().getPressedColors() : (isRollover ? AbstractLookAndFeel.getTheme().getRolloverColors() : AbstractLookAndFeel.getTheme().getButtonColors())) : AbstractLookAndFeel.getTheme().getDisabledColors();
            Color hiFrameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 20.0);
            Color loFrameColor = ColorHelper.darker(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 60.0);
            Shape savedClip = g2.getClip();
            Area clipArea = new Area(new Ellipse2D.Double(x2, y2, 17.0, 17.0));
            clipArea.intersect(new Area(savedClip));
            g2D.setClip(clipArea);
            JTattooUtilities.fillHorGradient(g2, colors, x2, y2, 16, 16);
            g2D.setClip(savedClip);
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (ColorHelper.getGrayValue(AbstractLookAndFeel.getButtonForegroundColor()) > 128) {
                g2.setColor(hiFrameColor);
                g2.drawOval(x2, y2, 16, 16);
            } else {
                g2.setColor(loFrameColor);
                g2.drawOval(x2 - 1, y2 - 1, 18, 18);
                g2.drawOval(x2, y2, 16, 16);
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            if (model.isSelected()) {
                int xi = x2 + (16 - radioIcon.getIconWidth()) / 2 + 1;
                int yi = y2 + (16 - radioIcon.getIconHeight()) / 2 + 1;
                if (ColorHelper.getGrayValue(AbstractLookAndFeel.getButtonForegroundColor()) > 128) {
                    radioIcon.paintIcon(c2, g2, xi, yi);
                } else {
                    baseRadioIcon.paintIcon(c2, g2, xi, yi);
                }
            }
        }

        public int getIconWidth() {
            return 20;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static Icon checkIcon = new LazyImageIcon("hifi/icons/CheckSymbol.gif");
        private static Icon checkPressedIcon = new LazyImageIcon("hifi/icons/CheckPressedSymbol.gif");
        private static Icon baseCheckIcon = new LazyImageIcon("icons/CheckSymbol.gif");
        private final int WIDTH = 17;
        private final int HEIGHT = 17;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            if (!JTattooUtilities.isLeftToRight(c2)) {
                x2 += 4;
            }
            g2.translate(x2, y2);
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            Graphics2D g2D = (Graphics2D)g2;
            boolean isRollover = button.isRolloverEnabled() && model.isRollover();
            Color[] colors = null;
            colors = button.isEnabled() ? (isRollover ? AbstractLookAndFeel.getTheme().getRolloverColors() : (model.isPressed() ? AbstractLookAndFeel.getTheme().getPressedColors() : AbstractLookAndFeel.getTheme().getButtonColors())) : AbstractLookAndFeel.getTheme().getDisabledColors();
            JTattooUtilities.fillHorGradient(g2, colors, 1, 1, 16, 16);
            Color hiFrameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 14.0);
            Color frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 6.0);
            Color loFrameColor = ColorHelper.darker(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 50.0);
            g2.setColor(hiFrameColor);
            g2.drawLine(1, 0, 14, 0);
            g2.drawLine(0, 1, 0, 14);
            g2.setColor(frameColor);
            g2.drawLine(15, 1, 15, 14);
            g2.drawLine(1, 15, 14, 15);
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
            g2D.setComposite(alpha);
            g2D.setColor(loFrameColor);
            g2.drawLine(1, 1, 14, 1);
            g2.drawLine(1, 2, 1, 14);
            g2.setColor(Color.black);
            g2.drawLine(16, 1, 16, 16);
            g2.drawLine(1, 16, 16, 16);
            alpha = AlphaComposite.getInstance(3, 0.2f);
            g2D.setComposite(alpha);
            g2.drawLine(1, 15, 2, 16);
            g2D.setComposite(composite);
            int xi = (17 - checkIcon.getIconWidth()) / 2;
            int yi = (17 - checkIcon.getIconHeight()) / 2;
            if (model.isPressed() && model.isArmed()) {
                checkPressedIcon.paintIcon(c2, g2, xi, yi);
            } else if (model.isSelected()) {
                if (ColorHelper.getGrayValue(AbstractLookAndFeel.getButtonForegroundColor()) > 128) {
                    checkIcon.paintIcon(c2, g2, xi, yi);
                } else {
                    baseCheckIcon.paintIcon(c2, g2, xi, yi);
                }
            }
            g2.translate(-x2, -y2);
        }

        public int getIconWidth() {
            return 21;
        }

        public int getIconHeight() {
            return 17;
        }
    }
}

