/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class GraphiteTitlePane
extends BaseTitlePane {
    public GraphiteTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    protected int getHorSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 1 : 0;
    }

    protected int getVerSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 3 : 0;
    }

    protected boolean centerButtons() {
        return false;
    }

    public void paintBorder(Graphics g2) {
        if (this.isActive()) {
            g2.setColor(ColorHelper.darker(AbstractLookAndFeel.getWindowBorderColor(), 10.0));
        } else {
            g2.setColor(ColorHelper.darker(AbstractLookAndFeel.getWindowInactiveBorderColor(), 10.0));
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x2, int y2, String title) {
        x2 += this.paintIcon(g2, x2, y2);
        Graphics2D g2D = (Graphics2D)g2;
        ColorUIResource fc = AbstractLookAndFeel.getWindowTitleForegroundColor();
        if (fc.equals(Color.white)) {
            ColorUIResource bc = AbstractLookAndFeel.getWindowTitleColorDark();
            g2D.setColor(bc);
            JTattooUtilities.drawString(this.rootPane, g2, title, x2 - 1, y2 - 1);
            g2D.setColor(ColorHelper.darker(bc, 30.0));
            JTattooUtilities.drawString(this.rootPane, g2, title, x2 + 1, y2 + 1);
        }
        g2.setColor(fc);
        JTattooUtilities.drawString(this.rootPane, g2, title, x2, y2);
    }
}

