/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class GraphiteBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return GraphiteBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new MenuItemBorder();
        }
        return menuItemBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = AbstractLookAndFeel.getTheme().isMenuOpaque() ? new PopupMenuBorder() : new BaseBorders.BasePopupMenuShadowBorder();
        }
        return popupMenuBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public Insets getBorderInsets(Component c2) {
            return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = this.insets.left;
            borderInsets.top = this.insets.top;
            borderInsets.right = this.insets.right;
            borderInsets.bottom = this.insets.bottom;
            return borderInsets;
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            int th = this.getTitleHeight(c2);
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowTitleColorLight();
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowTitleColorDark();
            ColorUIResource frameColor = AbstractLookAndFeel.getWindowBorderColor();
            if (!this.isActive(c2)) {
                titleColor = AbstractLookAndFeel.getWindowInactiveTitleColorLight();
                borderColor = AbstractLookAndFeel.getWindowInactiveTitleColorDark();
                frameColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            }
            g2.setColor(titleColor);
            g2.fillRect(x2, y2 + 1, w2, this.insets.top - 1);
            g2.setColor(titleColor);
            g2.fillRect(x2 + 1, y2 + h2 - 5, w2 - 2, 4);
            if (this.isActive(c2)) {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, th + 1);
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w2 - 5 - 1, this.insets.top, 5, th + 1);
                g2.setColor(borderColor);
                JTattooUtilities.fillInverseHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top + th + 1, 4, h2 - th - 5);
                JTattooUtilities.fillInverseHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w2 - 5, this.insets.top + th + 1, 4, h2 - th - 5);
            } else {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 5, th + 1);
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w2 - 5 - 1, this.insets.top, 5, th + 1);
                g2.setColor(borderColor);
                JTattooUtilities.fillInverseHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top + th + 1, 4, h2 - th - 5);
                JTattooUtilities.fillInverseHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w2 - 5, this.insets.top + th + 1, 4, h2 - th - 5);
            }
            g2.setColor(frameColor);
            g2.drawRect(x2, y2, w2 - 1, h2 - 1);
            g2.drawLine(x2 + 5 - 1, y2 + this.insets.top + th, x2 + 5 - 1, y2 + h2 - 5);
            g2.drawLine(x2 + w2 - 5, y2 + this.insets.top + th, x2 + w2 - 5, y2 + h2 - 5);
            g2.drawLine(x2 + 5 - 1, y2 + h2 - 5, x2 + w2 - 5, y2 + h2 - 5);
        }
    }

    public static class PopupMenuBorder
    extends BaseBorders.BasePopupMenuBorder {
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            Color borderColor = ColorHelper.darker(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 20.0);
            if (JTattooUtilities.isLeftToRight(c2)) {
                int dx = this.getBorderInsets((Component)c2).left;
                ColorUIResource logoColorHi = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColorDark();
                ColorUIResource logoColorLo = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
                Color[] colors = ColorHelper.createColorArr(logoColorHi, logoColorLo, 32);
                JTattooUtilities.fillHorGradient(g2, colors, x2, y2, dx - 1, h2 - 1);
                this.paintLogo(c2, g2, x2, y2, w2, h2);
                g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g2.drawLine(x2 + dx, y2 + 1, x2 + w2 - 2, y2 + 1);
                g2.setColor(borderColor);
                if (this.isMenuBarPopup(c2)) {
                    g2.drawLine(x2 + dx - 1, y2, x2 + w2, y2);
                    g2.drawLine(x2, y2, x2, y2 + h2 - 1);
                    g2.drawLine(x2, y2 + h2 - 1, x2 + w2, y2 + h2 - 1);
                    g2.drawLine(x2 + w2 - 1, y2 + 1, x2 + w2 - 1, y2 + h2 - 1);
                } else {
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                }
                g2.drawLine(x2 + dx - 1, y2 + 1, x2 + dx - 1, y2 + h2 - 1);
            } else {
                int dx = this.getBorderInsets((Component)c2).right;
                ColorUIResource logoColorHi = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColorDark();
                ColorUIResource logoColorLo = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
                Color[] colors = ColorHelper.createColorArr(logoColorHi, logoColorLo, 32);
                JTattooUtilities.fillHorGradient(g2, colors, x2 + w2 - dx, y2, dx, h2 - 1);
                this.paintLogo(c2, g2, x2, y2, w2, h2);
                g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g2.drawLine(x2 + 1, y2 + 1, x2 + w2 - dx - 1, y2 + 1);
                g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + h2 - 2);
                g2.setColor(borderColor);
                if (this.isMenuBarPopup(c2)) {
                    g2.drawLine(x2, y2, x2 + w2 - dx, y2);
                    g2.drawLine(x2, y2, x2, y2 + h2 - 1);
                    g2.drawLine(x2, y2 + h2 - 1, x2 + w2, y2 + h2 - 1);
                    g2.drawLine(x2 + w2 - 1, y2, x2 + w2 - 1, y2 + h2 - 1);
                } else {
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                }
                g2.drawLine(x2 + w2 - dx, y2 + 1, x2 + w2 - dx, y2 + h2 - 1);
            }
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            JMenuItem b2 = (JMenuItem)c2;
            ButtonModel model = b2.getModel();
            Color borderColor = ColorHelper.darker(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 20.0);
            g2.setColor(borderColor);
            if (c2.getParent() instanceof JMenuBar) {
                if (model.isArmed() || model.isSelected()) {
                    g2.drawLine(x2, y2, x2 + w2 - 1, y2);
                    g2.drawLine(x2, y2 + 1, x2, y2 + h2 - 1);
                    g2.drawLine(x2 + w2 - 1, y2 + 1, x2 + w2 - 1, y2 + h2 - 1);
                }
            } else if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                g2.drawLine(x2, y2, x2 + w2 - 1, y2);
                g2.drawLine(x2, y2 + h2 - 1, x2 + w2 - 1, y2 + h2 - 1);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(MenuItemBorder.insets.top, MenuItemBorder.insets.left, MenuItemBorder.insets.bottom, MenuItemBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = MenuItemBorder.insets.left;
            borderInsets.top = MenuItemBorder.insets.top;
            borderInsets.right = MenuItemBorder.insets.right;
            borderInsets.bottom = MenuItemBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            Color loColor = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 50.0);
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.black);
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.white);
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultColorHi = new Color(220, 230, 245);
        private static final Color defaultColorMed = new Color(212, 224, 243);
        private static final Color defaultColorLo = new Color(200, 215, 240);
        private static final Insets insets = new Insets(3, 8, 3, 8);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            Graphics2D g2D = (Graphics2D)g2;
            AbstractButton b2 = (AbstractButton)c2;
            Color frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 30.0);
            if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b2.hasFocus()) {
                frameColor = AbstractLookAndFeel.getTheme().getFocusFrameColor();
            }
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRoundRect(x2, y2, w2 - 1, h2 - 1, 6, 6);
            g2D.setComposite(savedComposite);
            if (b2.getRootPane() != null && b2.equals(b2.getRootPane().getDefaultButton()) && !b2.hasFocus()) {
                g2D.setColor(ColorHelper.darker(frameColor, 20.0));
                g2D.drawRoundRect(x2, y2, w2 - 1, h2 - 2, 6, 6);
                if (!b2.getModel().isRollover()) {
                    g2D.setColor(defaultColorHi);
                    g2D.drawRoundRect(x2 + 1, y2 + 1, w2 - 3, h2 - 4, 6, 6);
                    g2D.setColor(defaultColorMed);
                    g2D.drawRoundRect(x2 + 2, y2 + 2, w2 - 5, h2 - 6, 6, 6);
                    g2D.setColor(defaultColorLo);
                    g2D.drawLine(x2 + 3, h2 - 3, w2 - 3, h2 - 3);
                    g2D.drawLine(w2 - 2, y2 + 4, w2 - 2, h2 - 4);
                }
            } else {
                g2D.setColor(frameColor);
                g2D.drawRoundRect(x2, y2, w2 - 1, h2 - 2, 6, 6);
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

