/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseSliderUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class FastSliderUI
extends BaseSliderUI {
    private static ThumbHorIcon thumbHorIcon = new ThumbHorIcon();
    private static ThumbVerIcon thumbVerIcon = new ThumbVerIcon();

    public FastSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c2) {
        return new FastSliderUI((JSlider)c2);
    }

    public Icon getThumbHorIcon() {
        return thumbHorIcon;
    }

    public Icon getThumbHorIconRollover() {
        return thumbHorIcon;
    }

    public Icon getThumbVerIcon() {
        return thumbVerIcon;
    }

    public Icon getThumbVerIconRollover() {
        return thumbVerIcon;
    }

    public void paintTrack(Graphics g2) {
        boolean leftToRight = JTattooUtilities.isLeftToRight(this.slider);
        g2.translate(this.trackRect.x, this.trackRect.y);
        int overhang = 5;
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - overhang;
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - overhang - this.getTrackWidth();
                trackRight = this.trackRect.width - overhang - 1;
            } else {
                trackLeft = overhang;
                trackRight = overhang + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        g2.setColor(Color.gray);
        g2.drawRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1);
        int middleOfThumb = 0;
        int fillTop = 0;
        int fillLeft = 0;
        int fillBottom = 0;
        int fillRight = 0;
        if (this.slider.getOrientation() == 0) {
            middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
            middleOfThumb -= this.trackRect.x;
            fillTop = trackTop + 1;
            fillBottom = trackBottom - 2;
            if (!this.drawInverted()) {
                fillLeft = trackLeft + 1;
                fillRight = middleOfThumb;
            } else {
                fillLeft = middleOfThumb;
                fillRight = trackRight - 2;
            }
            g2.setColor(AbstractLookAndFeel.getControlBackgroundColor());
            g2.fillRect(fillLeft, fillTop, fillRight - fillLeft, fillBottom - fillTop + 1);
        } else {
            middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
            middleOfThumb -= this.trackRect.y;
            fillLeft = trackLeft + 1;
            fillRight = trackRight - 2;
            if (!this.drawInverted()) {
                fillTop = middleOfThumb;
                fillBottom = trackBottom - 2;
            } else {
                fillTop = trackTop + 1;
                fillBottom = middleOfThumb;
            }
            g2.setColor(AbstractLookAndFeel.getControlBackgroundColor());
            g2.fillRect(fillLeft, fillTop, fillRight - fillLeft + 1, fillBottom - fillTop + 1);
        }
        g2.translate(-this.trackRect.x, -this.trackRect.y);
    }

    private static class ThumbVerIcon
    implements Icon {
        private static final int WIDTH = 18;
        private static final int HEIGHT = 11;

        private ThumbVerIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            int w2 = 17;
            int h2 = 10;
            int dh = 5;
            ColorUIResource backColor = AbstractLookAndFeel.getControlBackgroundColor();
            ColorUIResource loColor = AbstractLookAndFeel.getFrameColor();
            Color hiColor = ColorHelper.brighter(backColor, 40.0);
            Polygon poly = new Polygon();
            poly.addPoint(x2, y2);
            poly.addPoint(x2 + w2 - dh, y2);
            poly.addPoint(x2 + w2, y2 + dh);
            poly.addPoint(x2 + w2 - dh, y2 + h2);
            poly.addPoint(x2, y2 + h2);
            g2.setColor(backColor);
            g2.fillPolygon(poly);
            g2.setColor(loColor);
            g2.drawPolygon(poly);
            g2.setColor(hiColor);
            g2.drawLine(x2 + 1, y2 + 1, x2 + w2 - dh, y2 + 1);
            g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + h2 - 1);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    private static class ThumbHorIcon
    implements Icon {
        private static final int WIDTH = 11;
        private static final int HEIGHT = 18;

        private ThumbHorIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            int w2 = 10;
            int h2 = 17;
            int dw = 5;
            ColorUIResource backColor = AbstractLookAndFeel.getControlBackgroundColor();
            ColorUIResource loColor = AbstractLookAndFeel.getFrameColor();
            Color hiColor = ColorHelper.brighter(backColor, 40.0);
            Polygon poly = new Polygon();
            poly.addPoint(x2, y2);
            poly.addPoint(x2 + w2, y2);
            poly.addPoint(x2 + w2, y2 + h2 - dw);
            poly.addPoint(x2 + dw, y2 + h2);
            poly.addPoint(x2, y2 + h2 - dw);
            g2.setColor(backColor);
            g2.fillPolygon(poly);
            g2.setColor(loColor);
            g2.drawPolygon(poly);
            g2.setColor(hiColor);
            g2.drawLine(x2 + 1, y2 + 1, x2 + w2 - 1, y2 + 1);
            g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + h2 - dw);
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 18;
        }
    }
}

