/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class FastBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return FastBorders.getButtonBorder();
    }

    public static Border getToolButtonBorder() {
        if (toolButtonBorder == null) {
            toolButtonBorder = new ToolButtonBorder();
        }
        return toolButtonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            boolean active = this.isActive(c2);
            boolean resizable = this.isResizable(c2);
            ColorUIResource frameColor = AbstractLookAndFeel.getFrameColor();
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            if (active) {
                borderColor = AbstractLookAndFeel.getWindowBorderColor();
            }
            Color cHi = ColorHelper.brighter(frameColor, 40.0);
            Color cLo = frameColor;
            if (!resizable) {
                JTattooUtilities.draw3DBorder(g2, cHi, cLo, x2, y2, w2, h2);
                g2.setColor(borderColor);
                for (int i2 = 1; i2 < 5; ++i2) {
                    g2.drawRect(i2, i2, w2 - 2 * i2 - 1, h2 - 2 * i2 - 1);
                }
                return;
            }
            JTattooUtilities.draw3DBorder(g2, cHi, cLo, x2, y2, w2, h2);
            cHi = ColorHelper.brighter(borderColor, 40.0);
            cLo = ColorHelper.darker(borderColor, 20.0);
            JTattooUtilities.draw3DBorder(g2, cHi, cLo, x2 + 1, y2 + 1, w2 - 2, h2 - 2);
            g2.setColor(borderColor);
            g2.drawRect(x2 + 2, y2 + 2, w2 - 5, h2 - 5);
            g2.drawRect(x2 + 3, y2 + 3, w2 - 7, h2 - 7);
            JTattooUtilities.draw3DBorder(g2, ColorHelper.darker(borderColor, 5.0), ColorHelper.brighter(borderColor, 30.0), x2 + 4, y2 + 4, w2 - 8, h2 - 8);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            ColorUIResource loColor = AbstractLookAndFeel.getFrameColor();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.black);
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.white);
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            Color hiColor = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 90.0);
            ColorUIResource loColor = AbstractLookAndFeel.getFrameColor();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.black);
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                } else {
                    JTattooUtilities.draw3DBorder(g2, hiColor, loColor, 0, 0, w2, h2);
                }
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(ToolButtonBorder.insets.top, ToolButtonBorder.insets.left, ToolButtonBorder.insets.bottom, ToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ToolButtonBorder.insets.left;
            borderInsets.top = ToolButtonBorder.insets.top;
            borderInsets.right = ToolButtonBorder.insets.right;
            borderInsets.bottom = ToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultFrameColor = new Color(0, 64, 255);
        private static final Insets insets = new Insets(4, 8, 4, 8);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            Color frameColor = ColorHelper.darker(button.getBackground(), 30.0);
            if (model.isEnabled()) {
                JButton b2;
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    g2.setColor(frameColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                } else {
                    g2.setColor(frameColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    g2.setColor(ColorHelper.brighter(button.getBackground(), 40.0));
                    g2.drawLine(x2 + 1, y2 + 1, x2 + w2 - 2, y2 + 1);
                    g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + h2 - 2);
                }
                if (c2 instanceof JButton && (b2 = (JButton)c2).equals(b2.getRootPane().getDefaultButton())) {
                    g2.setColor(defaultFrameColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                }
            } else {
                g2.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                g2.drawRect(x2, y2, w2 - 1, h2 - 1);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

