/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.aluminium.AluminiumUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class AluminiumTabbedPaneUI
extends BaseTabbedPaneUI {
    private static Color[] TOP_SELECTED_TAB_COLORS = null;
    private static Color[] BOTTOM_SELECTED_TAB_COLORS = null;

    public static ComponentUI createUI(JComponent c2) {
        return new AluminiumTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets = new Insets(2, 6, 2, 6);
        this.contentBorderInsets = new Insets(0, 0, 0, 0);
        ColorUIResource c2 = AbstractLookAndFeel.getTheme().getBackgroundColor();
        Color cHi = ColorHelper.brighter(c2, 20.0);
        Color cLo = ColorHelper.darker(c2, 10.0);
        TOP_SELECTED_TAB_COLORS = ColorHelper.createColorArr(cHi, c2, 20);
        BOTTOM_SELECTED_TAB_COLORS = ColorHelper.createColorArr(c2, cLo, 20);
    }

    protected Font getTabFont(boolean isSelected) {
        if (isSelected) {
            return super.getTabFont(isSelected).deriveFont(1);
        }
        return super.getTabFont(isSelected);
    }

    protected Color[] getTabColors(int tabIndex, boolean isSelected, boolean isRollover) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (backColor instanceof UIResource && isSelected) {
            if (this.tabPane.getTabPlacement() == 3) {
                return BOTTOM_SELECTED_TAB_COLORS;
            }
            return TOP_SELECTED_TAB_COLORS;
        }
        return super.getTabColors(tabIndex, isSelected, isRollover);
    }

    protected boolean hasInnerBorder() {
        return true;
    }

    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x2, int y2, int w2, int h2, boolean isSelected) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (!(backColor instanceof UIResource)) {
            super.paintTabBackground(g2, tabPlacement, tabIndex, x2, y2, w2, h2, isSelected);
            return;
        }
        if (JTattooUtilities.isMac() || !AbstractLookAndFeel.getTheme().isBackgroundPatternOn()) {
            if (isSelected) {
                Color[] colorArr = this.getTabColors(tabIndex, isSelected, tabIndex == this.rolloverIndex);
                switch (tabPlacement) {
                    case 2: {
                        JTattooUtilities.fillHorGradient(g2, colorArr, x2 + 1, y2 + 1, w2 + 1, h2 - 1);
                        break;
                    }
                    case 4: {
                        JTattooUtilities.fillHorGradient(g2, colorArr, x2 - 1, y2 + 1, w2 + 1, h2 - 1);
                        break;
                    }
                    case 3: {
                        JTattooUtilities.fillHorGradient(g2, colorArr, x2 + 1, y2 - 1, w2 - 1, h2);
                        break;
                    }
                    default: {
                        JTattooUtilities.fillHorGradient(g2, colorArr, x2 + 1, y2 + 1, w2 - 1, h2 + 1);
                        break;
                    }
                }
            } else {
                super.paintTabBackground(g2, tabPlacement, tabIndex, x2, y2, w2, h2, isSelected);
            }
        } else if (isSelected) {
            if (this.tabPane.getBackgroundAt(tabIndex) instanceof UIResource) {
                g2.setColor(AbstractLookAndFeel.getBackgroundColor());
                if (tabPlacement == 1) {
                    AluminiumUtils.fillComponent(g2, this.tabPane, x2 + 1, y2 + 1, w2 - 1, h2 + 1);
                } else if (tabPlacement == 2) {
                    AluminiumUtils.fillComponent(g2, this.tabPane, x2 + 1, y2 + 1, w2 + 1, h2 - 1);
                } else if (tabPlacement == 3) {
                    AluminiumUtils.fillComponent(g2, this.tabPane, x2 + 1, y2 - 2, w2 - 1, h2 + 1);
                } else {
                    AluminiumUtils.fillComponent(g2, this.tabPane, x2 - 1, y2 + 1, w2 + 1, h2 - 1);
                }
            } else {
                super.paintTabBackground(g2, tabPlacement, tabIndex, x2, y2, w2, h2, isSelected);
            }
        } else {
            super.paintTabBackground(g2, tabPlacement, tabIndex, x2, y2, w2, h2, isSelected);
        }
    }
}

