/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class AluminiumBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return AluminiumBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            ColorUIResource c1;
            Graphics2D g2D = (Graphics2D)g2;
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowInactiveTitleBackgroundColor();
            if (this.isActive(c2)) {
                titleColor = AbstractLookAndFeel.getWindowTitleBackgroundColor();
            }
            int th = this.getTitleHeight(c2);
            g2.setColor(titleColor);
            g2.fillRect(1, 1, w2, 5);
            g2.fillRect(1, h2 - 5, w2, 4);
            if (this.isActive(c2)) {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w2 - 5, 5, 5, th + 1);
                c1 = AbstractLookAndFeel.getTheme().getWindowTitleColorDark();
                ColorUIResource c22 = AbstractLookAndFeel.getTheme().getWindowTitleColorLight();
                g2D.setPaint(new GradientPaint(0.0f, 5 + th + 1, c1, 0.0f, h2 - th - 10, c22));
                g2.fillRect(1, 5 + th + 1, 4, h2 - th - 10);
                g2.fillRect(w2 - 5, 5 + th + 1, 4, h2 - th - 10);
                g2D.setPaint(null);
            } else {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w2 - 5, 5, 5, th + 1);
                c1 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark();
                ColorUIResource c23 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight();
                g2D.setPaint(new GradientPaint(0.0f, 5 + th + 1, c1, 0.0f, h2 - th - 10, c23));
                g2.fillRect(1, 5 + th + 1, 4, h2 - th - 10);
                g2.fillRect(w2 - 5, 5 + th + 1, 4, h2 - th - 10);
                g2D.setPaint(null);
            }
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            if (this.isActive(c2)) {
                borderColor = AbstractLookAndFeel.getWindowBorderColor();
            }
            g2.setColor(borderColor);
            g2.drawRect(0, 0, w2 - 1, h2 - 1);
            g2.drawLine(x2 + 5 - 1, y2 + this.insets.top + th, x2 + 5 - 1, y2 + h2 - 5);
            g2.drawLine(x2 + w2 - 5, y2 + this.insets.top + th, x2 + w2 - 5, y2 + h2 - 5);
            g2.drawLine(x2 + 5 - 1, y2 + h2 - 5, x2 + w2 - 5, y2 + h2 - 5);
            g2.setColor(new Color(220, 220, 220));
            g2.drawLine(1, 1, w2 - 3, 1);
            g2.drawLine(1, 1, 1, h2 - 2);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            ColorUIResource loColor = AbstractLookAndFeel.getFrameColor();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.black);
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    g2.setColor(loColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g2.setColor(AbstractLookAndFeel.getTheme().getSelectionBackgroundColor());
                    g2.fillRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
                    g2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
        }

        public Insets getBorderInsets(Component c2) {
            if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
                return new Insets(3, 4, 3, 4);
            }
            return new Insets(2, 12, 2, 12);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            Insets insets = this.getBorderInsets(c2);
            borderInsets.left = insets.left;
            borderInsets.top = insets.top;
            borderInsets.right = insets.right;
            borderInsets.bottom = insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

