/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aero;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;

public class AeroInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public AeroInternalFrameTitlePane(JInternalFrame f2) {
        super(f2);
    }

    protected int getHorSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 1 : 0;
    }

    protected int getVerSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 3 : 0;
    }

    protected void createButtons() {
        if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
            super.createButtons();
        } else {
            this.iconButton = new TitleButton(this.iconifyAction, "Iconify", this.iconIcon);
            this.maxButton = new TitleButton(this.maximizeAction, "Maximize", this.maxIcon);
            this.closeButton = new TitleButton(this.closeAction, "Close", this.closeIcon);
            this.setButtonIcons();
        }
    }

    public void paintBorder(Graphics g2) {
        if (this.isActive()) {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorDark(), 50.0));
        } else {
            g2.setColor(ColorHelper.darker(AbstractLookAndFeel.getWindowInactiveTitleColorDark(), 10.0));
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x2, int y2, String title) {
        if (this.isMacStyleWindowDecoration()) {
            x2 += this.paintIcon(g2, x2, y2) + 5;
        }
        if (this.isActive()) {
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowTitleForegroundColor();
            if (ColorHelper.getGrayValue(titleColor) > 164) {
                g2.setColor(Color.black);
            } else {
                g2.setColor(Color.white);
            }
            JTattooUtilities.drawString(this.frame, g2, title, x2 + 1, y2 + 1);
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, g2, title, x2, y2);
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, g2, title, x2, y2);
        }
    }

    private class TitleButton
    extends BaseTitleButton {
        public TitleButton(Action action, String accessibleName, Icon icon) {
            super(action, accessibleName, icon, 1.0f);
        }

        public void paint(Graphics g2) {
            boolean isPressed = this.getModel().isPressed();
            boolean isArmed = this.getModel().isArmed();
            boolean isRollover = this.getModel().isRollover();
            int width = this.getWidth();
            int height = this.getHeight();
            Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
            if (isRollover) {
                colors = AbstractLookAndFeel.getTheme().getRolloverColors();
            }
            if (isPressed && isArmed) {
                colors = AbstractLookAndFeel.getTheme().getPressedColors();
            }
            JTattooUtilities.fillHorGradient(g2, colors, 0, 0, width, height);
            g2.setColor(Color.lightGray);
            g2.drawLine(0, 0, 0, height);
            g2.drawLine(0, height - 1, width, height - 1);
            g2.setColor(Color.white);
            g2.drawLine(1, 0, 1, height - 2);
            this.getIcon().paintIcon(this, g2, 1, 0);
        }
    }
}

