/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class AcrylTitlePane
extends BaseTitlePane {
    public AcrylTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 1;
    }

    protected int getVerSpacing() {
        return 3;
    }

    public void paintBorder(Graphics g2) {
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getWindowBorderColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x2, int y2, String title) {
        x2 += this.paintIcon(g2, x2, y2);
        Color shadowColor = AbstractLookAndFeel.getWindowTitleColorDark();
        if (this.isActive()) {
            shadowColor = ColorHelper.darker(shadowColor, 30.0);
        }
        g2.setColor(shadowColor);
        JTattooUtilities.drawString(this.rootPane, g2, title, x2 - 1, y2 - 1);
        JTattooUtilities.drawString(this.rootPane, g2, title, x2 - 1, y2 + 1);
        JTattooUtilities.drawString(this.rootPane, g2, title, x2 + 1, y2 - 1);
        JTattooUtilities.drawString(this.rootPane, g2, title, x2 + 1, y2 + 1);
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.rootPane, g2, title, x2, y2);
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c2) {
        }

        public void removeLayoutComponent(Component c2) {
        }

        public Dimension preferredLayoutSize(Container c2) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c2) {
            return this.preferredLayoutSize(c2);
        }

        protected int computeHeight() {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(AcrylTitlePane.this.getFont());
            return fm.getHeight() + 5;
        }

        public void layoutContainer(Container c2) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c2);
            } else {
                this.layoutDefault(c2);
            }
        }

        public void layoutDefault(Container c2) {
            boolean leftToRight = AcrylTitlePane.this.isLeftToRight();
            int spacing = AcrylTitlePane.this.getHorSpacing();
            int w2 = AcrylTitlePane.this.getWidth();
            int h2 = AcrylTitlePane.this.getHeight();
            int buttonHeight = h2 - AcrylTitlePane.this.getVerSpacing();
            int buttonWidth = buttonHeight + 10;
            int x2 = leftToRight ? spacing : w2 - buttonWidth - spacing;
            int y2 = Math.max(0, (h2 - buttonHeight) / 2 - 1);
            int cpx = 0;
            int cpy = 0;
            int cpw = AcrylTitlePane.this.getWidth();
            int cph = AcrylTitlePane.this.getHeight();
            if (AcrylTitlePane.this.menuBar != null) {
                int mw = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().width;
                int mh = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().height;
                if (leftToRight) {
                    cpx = 4 + mw;
                    AcrylTitlePane.this.menuBar.setBounds(2, (h2 - mh) / 2, mw, mh);
                } else {
                    AcrylTitlePane.this.menuBar.setBounds(AcrylTitlePane.this.getWidth() - mw, (h2 - mh) / 2, mw, mh);
                }
                cpw -= 4 + mw;
            }
            int n2 = x2 = leftToRight ? w2 - spacing : 0;
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(x2 += leftToRight ? -buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                AcrylTitlePane.this.maxButton.setBounds(x2 += leftToRight ? -spacing - buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(x2 += leftToRight ? -spacing - buttonWidth : spacing, y2, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x2 += buttonWidth;
                }
            }
            AcrylTitlePane.this.buttonsWidth = leftToRight ? w2 - x2 : x2;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                if (!leftToRight) {
                    cpx += AcrylTitlePane.this.buttonsWidth;
                }
                cpw -= AcrylTitlePane.this.buttonsWidth;
                Graphics g2 = AcrylTitlePane.this.getGraphics();
                if (g2 != null) {
                    FontMetrics fm = g2.getFontMetrics();
                    int tw = SwingUtilities.computeStringWidth(fm, JTattooUtilities.getClippedText(AcrylTitlePane.this.getTitle(), fm, cpw));
                    if (leftToRight) {
                        cpx += tw;
                    }
                    cpw -= tw;
                }
                AcrylTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
            }
        }

        private void layoutMacStyle(Container c2) {
            int buttonHeight;
            int spacing = AcrylTitlePane.this.getHorSpacing();
            int h2 = AcrylTitlePane.this.getHeight();
            int buttonWidth = buttonHeight = h2 - AcrylTitlePane.this.getVerSpacing();
            int x2 = 0;
            int y2 = 0;
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                AcrylTitlePane.this.maxButton.setBounds(x2, y2, buttonWidth, buttonHeight);
                x2 += buttonWidth + spacing;
            }
            AcrylTitlePane.this.buttonsWidth = x2;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                int cpx = AcrylTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((AcrylTitlePane)AcrylTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h2;
                AcrylTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                AcrylTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }
}

