/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class AcrylScrollBarUI
extends BaseScrollBarUI {
    public static ComponentUI createUI(JComponent c2) {
        return new AcrylScrollBarUI();
    }

    protected JButton createDecreaseButton(int orientation) {
        return new BaseScrollButton(orientation, this.scrollBarWidth);
    }

    protected JButton createIncreaseButton(int orientation) {
        return new BaseScrollButton(orientation, this.scrollBarWidth);
    }

    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        g2.translate(thumbBounds.x, thumbBounds.y);
        Color[] colors = this.getThumbColors();
        Color frameColor = AbstractLookAndFeel.getFrameColor();
        if (!JTattooUtilities.isActive(this.scrollbar)) {
            frameColor = ColorHelper.brighter(frameColor, 80.0);
        }
        if (this.isRollover || this.isDragging) {
            frameColor = AbstractLookAndFeel.getTheme().getRolloverColorDark();
        }
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(g2, colors, 1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
            JTattooUtilities.draw3DBorder(g2, frameColor, ColorHelper.darker(frameColor, 15.0), 0, 0, thumbBounds.width, thumbBounds.height);
            Graphics2D g2D = (Graphics2D)g2;
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
            g2D.setComposite(alpha);
            int dx = 5;
            int dy = thumbBounds.height / 2 - 3;
            int dw = thumbBounds.width - 11;
            Color c1 = Color.white;
            Color c22 = Color.darkGray;
            for (int i2 = 0; i2 < 4; ++i2) {
                g2.setColor(c1);
                g2.drawLine(dx, dy, dx + dw, dy);
                g2.setColor(c22);
                g2.drawLine(dx, ++dy, dx + dw, dy);
                ++dy;
            }
            g2D.setComposite(composite);
        } else {
            JTattooUtilities.fillHorGradient(g2, colors, 1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
            JTattooUtilities.draw3DBorder(g2, frameColor, ColorHelper.darker(frameColor, 10.0), 0, 0, thumbBounds.width, thumbBounds.height);
            int dx = thumbBounds.width / 2 - 3;
            int dy = 5;
            int dh = thumbBounds.height - 11;
            Graphics2D g2D = (Graphics2D)g2;
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
            g2D.setComposite(alpha);
            Color c1 = Color.white;
            Color c23 = Color.darkGray;
            for (int i3 = 0; i3 < 4; ++i3) {
                g2.setColor(c1);
                g2.drawLine(dx, dy, dx, dy + dh);
                g2.setColor(c23);
                g2.drawLine(++dx, dy, dx, dy + dh);
                ++dx;
            }
            g2D.setComposite(composite);
        }
        g2.translate(-thumbBounds.x, -thumbBounds.y);
    }
}

