/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Icon;

public abstract class XPScrollButton
extends BaseScrollButton {
    public XPScrollButton(int direction, int width) {
        super(direction, width);
    }

    public abstract Icon getUpArrowIcon();

    public abstract Icon getDownArrowIcon();

    public abstract Icon getLeftArrowIcon();

    public abstract Icon getRightArrowIcon();

    public Color getFrameColor() {
        return Color.white;
    }

    public void paint(Graphics g2) {
        Graphics2D g2D = (Graphics2D)g2;
        Composite savedComposite = g2D.getComposite();
        Paint savedPaint = g2D.getPaint();
        boolean isPressed = this.getModel().isPressed();
        boolean isRollover = this.getModel().isRollover();
        int width = this.getWidth();
        int height = this.getHeight();
        Color[] tc = AbstractLookAndFeel.getTheme().getThumbColors();
        Color c1 = tc[0];
        Color c2 = tc[tc.length - 1];
        if (isPressed) {
            c1 = ColorHelper.darker(c1, 5.0);
            c2 = ColorHelper.darker(c2, 5.0);
        } else if (isRollover) {
            c1 = ColorHelper.brighter(c1, 20.0);
            c2 = ColorHelper.brighter(c2, 20.0);
        }
        g2D.setPaint(new GradientPaint(0.0f, 0.0f, c1, width, height, c2));
        g2.fillRect(0, 0, width, height);
        g2D.setPaint(savedPaint);
        g2.setColor(this.getFrameColor());
        g2.drawLine(1, 1, width - 2, 1);
        g2.drawLine(1, 1, 1, height - 3);
        g2.drawLine(width - 2, 1, width - 2, height - 3);
        g2.drawLine(2, height - 2, width - 3, height - 2);
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
        g2D.setComposite(alpha);
        g2D.setColor(c2);
        g2.drawLine(2, 2, width - 3, 2);
        g2.drawLine(2, 3, 2, height - 3);
        g2.setColor(ColorHelper.darker(c2, 40.0));
        g2.drawLine(width - 1, 2, width - 1, height - 3);
        g2.drawLine(3, height - 1, width - 3, height - 1);
        alpha = AlphaComposite.getInstance(3, 0.2f);
        g2D.setComposite(alpha);
        g2.drawLine(1, height - 2, 2, height - 1);
        g2.drawLine(width - 1, height - 2, width - 2, height - 1);
        g2D.setComposite(savedComposite);
        if (this.getDirection() == 1) {
            int x2 = width / 2 - this.getUpArrowIcon().getIconWidth() / 2;
            int y2 = height / 2 - this.getUpArrowIcon().getIconHeight() / 2;
            this.getUpArrowIcon().paintIcon(this, g2, x2, y2);
        } else if (this.getDirection() == 5) {
            int x3 = width / 2 - this.getDownArrowIcon().getIconWidth() / 2;
            int y3 = height / 2 - this.getDownArrowIcon().getIconHeight() / 2 + 1;
            this.getDownArrowIcon().paintIcon(this, g2, x3, y3);
        } else if (this.getDirection() == 7) {
            int x4 = width / 2 - this.getLeftArrowIcon().getIconWidth() / 2;
            int y4 = height / 2 - this.getLeftArrowIcon().getIconHeight() / 2;
            this.getLeftArrowIcon().paintIcon(this, g2, x4, y4);
        } else {
            int x5 = width / 2 - this.getRightArrowIcon().getIconWidth() / 2 + 1;
            int y5 = height / 2 - this.getRightArrowIcon().getIconHeight() / 2;
            this.getRightArrowIcon().paintIcon(this, g2, x5, y5);
        }
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }
}

