/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import java.awt.Color;

public class ColorHelper {
    private ColorHelper() {
    }

    public static Color createColor(int r2, int g2, int b2) {
        return new Color((r2 & 0xFF) << 16 | (g2 & 0xFF) << 8 | b2 & 0xFF);
    }

    public static Color[] createColorArr(Color c1, Color c2, int steps) {
        if (c1 == null || c2 == null) {
            return null;
        }
        Color[] colors = new Color[steps];
        double r2 = c1.getRed();
        double g2 = c1.getGreen();
        double b2 = c1.getBlue();
        double dr = ((double)c2.getRed() - r2) / (double)steps;
        double dg = ((double)c2.getGreen() - g2) / (double)steps;
        double db = ((double)c2.getBlue() - b2) / (double)steps;
        colors[0] = c1;
        for (int i2 = 1; i2 < steps - 1; ++i2) {
            colors[i2] = ColorHelper.createColor((int)(r2 += dr), (int)(g2 += dg), (int)(b2 += db));
        }
        colors[steps - 1] = c2;
        return colors;
    }

    public static Color brighter(Color c2, double p2) {
        if (c2 == null) {
            return null;
        }
        double r2 = c2.getRed();
        double g2 = c2.getGreen();
        double b2 = c2.getBlue();
        double rd = 255.0 - r2;
        double gd = 255.0 - g2;
        double bd = 255.0 - b2;
        return ColorHelper.createColor((int)(r2 += rd * p2 / 100.0), (int)(g2 += gd * p2 / 100.0), (int)(b2 += bd * p2 / 100.0));
    }

    public static Color darker(Color c2, double p2) {
        if (c2 == null) {
            return null;
        }
        double r2 = c2.getRed();
        double g2 = c2.getGreen();
        double b2 = c2.getBlue();
        r2 -= r2 * p2 / 100.0;
        g2 -= g2 * p2 / 100.0;
        b2 -= b2 * p2 / 100.0;
        return ColorHelper.createColor((int)r2, (int)g2, (int)b2);
    }

    public static Color median(Color c1, Color c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        int r2 = (c1.getRed() + c2.getRed()) / 2;
        int g2 = (c1.getGreen() + c2.getGreen()) / 2;
        int b2 = (c1.getBlue() + c2.getBlue()) / 2;
        return ColorHelper.createColor(r2, g2, b2);
    }

    public static int getGrayValue(Color c2) {
        if (c2 == null) {
            return 0;
        }
        double r2 = c2.getRed();
        double g2 = c2.getGreen();
        double b2 = c2.getBlue();
        return Math.min(255, (int)(r2 * 0.28 + g2 * 0.59 + b2 * 0.13));
    }

    public static int getGrayValue(Color[] ca) {
        int sum = 0;
        for (int i2 = 0; i2 < ca.length; ++i2) {
            sum += ColorHelper.getGrayValue(ca[i2]);
        }
        return sum / ca.length;
    }

    public static Color toGray(Color c2) {
        if (c2 == null) {
            return null;
        }
        int gray = ColorHelper.getGrayValue(c2);
        return new Color(gray, gray, gray, c2.getAlpha());
    }
}

