/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonListener;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class BaseToggleButtonUI
extends BasicToggleButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    protected static Color[] rolloverPressedColors = null;

    public static ComponentUI createUI(JComponent b2) {
        return new BaseToggleButtonUI();
    }

    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        b2.setOpaque(false);
        b2.setRolloverEnabled(true);
        Color[] cArr = AbstractLookAndFeel.getTheme().getPressedColors();
        rolloverPressedColors = new Color[cArr.length];
        for (int i2 = 0; i2 < cArr.length; ++i2) {
            BaseToggleButtonUI.rolloverPressedColors[i2] = ColorHelper.brighter(cArr[i2], 20.0);
        }
    }

    public void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
        b2.setOpaque(true);
        b2.setRolloverEnabled(false);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return new BaseButtonListener(b2);
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        if (!b2.isContentAreaFilled() || b2.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b2.getWidth();
        int height = b2.getHeight();
        ButtonModel model = b2.getModel();
        Color[] colors = null;
        colors = b2.isEnabled() ? (b2.getBackground() instanceof ColorUIResource ? (model.isPressed() && model.isArmed() ? AbstractLookAndFeel.getTheme().getPressedColors() : (b2.isRolloverEnabled() && model.isRollover() ? (model.isSelected() ? rolloverPressedColors : AbstractLookAndFeel.getTheme().getRolloverColors()) : (model.isSelected() ? AbstractLookAndFeel.getTheme().getPressedColors() : (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b2.hasFocus() ? AbstractLookAndFeel.getTheme().getFocusColors() : AbstractLookAndFeel.getTheme().getButtonColors())))) : (model.isPressed() && model.isArmed() ? ColorHelper.createColorArr(b2.getBackground(), ColorHelper.darker(b2.getBackground(), 50.0), 20) : (b2.isRolloverEnabled() && model.isRollover() ? ColorHelper.createColorArr(ColorHelper.brighter(b2.getBackground(), 80.0), ColorHelper.brighter(b2.getBackground(), 20.0), 20) : (model.isSelected() ? ColorHelper.createColorArr(b2.getBackground(), ColorHelper.darker(b2.getBackground(), 50.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(b2.getBackground(), 40.0), ColorHelper.darker(b2.getBackground(), 20.0), 20))))) : AbstractLookAndFeel.getTheme().getDisabledColors();
        JTattooUtilities.fillHorGradient(g2, colors, 1, 1, width - 2, height - 2);
    }

    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        ButtonModel model = b2.getModel();
        FontMetrics fm = g2.getFontMetrics();
        int mnemIndex = -1;
        mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b2.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b2.getText(), model.getMnemonic());
        if (model.isEnabled()) {
            int offs = 0;
            if (model.isArmed() && model.isPressed() || model.isSelected()) {
                offs = 1;
            }
            if (model.isRollover()) {
                g2.setColor(AbstractLookAndFeel.getTheme().getRolloverForegroundColor());
            } else {
                g2.setColor(b2.getForeground());
            }
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
        } else {
            g2.setColor(Color.white);
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            g2.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g2.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g2, 4, 3, b2.getWidth() - 8, b2.getHeight() - 6);
    }

    public void paint(Graphics g2, JComponent c2) {
        Graphics2D g2D = (Graphics2D)g2;
        AbstractButton b2 = (AbstractButton)c2;
        Font f2 = c2.getFont();
        g2.setFont(f2);
        FontMetrics fm = g2.getFontMetrics();
        Insets insets = c2.getInsets();
        BaseToggleButtonUI.viewRect.x = insets.left;
        BaseToggleButtonUI.viewRect.y = insets.top;
        BaseToggleButtonUI.viewRect.width = b2.getWidth() - (insets.right + BaseToggleButtonUI.viewRect.x);
        BaseToggleButtonUI.viewRect.height = b2.getHeight() - (insets.bottom + BaseToggleButtonUI.viewRect.y);
        BaseToggleButtonUI.textRect.height = 0;
        BaseToggleButtonUI.textRect.width = 0;
        BaseToggleButtonUI.textRect.y = 0;
        BaseToggleButtonUI.textRect.x = 0;
        BaseToggleButtonUI.iconRect.height = 0;
        BaseToggleButtonUI.iconRect.width = 0;
        BaseToggleButtonUI.iconRect.y = 0;
        BaseToggleButtonUI.iconRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : this.defaultTextIconGap);
        this.paintBackground(g2, b2);
        if (b2.getIcon() != null) {
            if (!b2.isEnabled()) {
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                this.paintIcon(g2, c2, iconRect);
                g2D.setComposite(savedComposite);
            } else {
                this.paintIcon(g2, c2, iconRect);
            }
        }
        if (text != null && !text.equals("") && textRect != null) {
            View v2 = (View)c2.getClientProperty("html");
            if (v2 != null) {
                Object savedRenderingHint = null;
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
                }
                v2.paint(g2, textRect);
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
                }
            } else {
                this.paintText(g2, b2, textRect, text);
            }
        }
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(g2, b2, viewRect, textRect, iconRect);
        }
    }
}

