/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractIconFactory;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;
    protected MouseAdapter myMouseAdapter = null;
    protected MouseMotionAdapter myMouseMotionAdapter = null;
    protected int rolloverCol = -1;

    public static ComponentUI createUI(JComponent h2) {
        return new BaseTableHeaderUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        if (this.header != null && this.header.getTable() != null) {
            this.originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this.originalHeaderRenderer != null && "sun.swing.table.DefaultTableCellHeaderRenderer".equals(this.originalHeaderRenderer.getClass().getName())) {
                this.header.setDefaultRenderer(new BaseDefaultHeaderRenderer());
            }
        }
    }

    public void uninstallUI(JComponent c2) {
        if (this.header != null && this.header.getTable() != null && this.header.getDefaultRenderer() instanceof BaseDefaultHeaderRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(c2);
    }

    public void installListeners() {
        super.installListeners();
        this.myMouseAdapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent e2) {
                if (BaseTableHeaderUI.this.header == null || BaseTableHeaderUI.this.header.getTable() == null) {
                    return;
                }
                boolean rolloverEnabled = Boolean.TRUE.equals(BaseTableHeaderUI.this.header.getClientProperty("rolloverEnabled"));
                boolean sortingAllowed = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl = sortingAllowed = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if (rolloverEnabled || sortingAllowed || BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    if (BaseTableHeaderUI.this.header.getBounds().contains(e2.getPoint())) {
                        int oldRolloverCol = BaseTableHeaderUI.this.rolloverCol;
                        BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(e2.getX());
                        BaseTableHeaderUI.this.updateRolloverColumn(oldRolloverCol, BaseTableHeaderUI.this.rolloverCol);
                    } else {
                        int oldRolloverCol = BaseTableHeaderUI.this.rolloverCol;
                        BaseTableHeaderUI.this.rolloverCol = -1;
                        BaseTableHeaderUI.this.updateRolloverColumn(oldRolloverCol, BaseTableHeaderUI.this.rolloverCol);
                    }
                }
            }

            public void mouseEntered(MouseEvent e2) {
                if (BaseTableHeaderUI.this.header == null || BaseTableHeaderUI.this.header.getTable() == null) {
                    return;
                }
                boolean rolloverEnabled = Boolean.TRUE.equals(BaseTableHeaderUI.this.header.getClientProperty("rolloverEnabled"));
                boolean sortingAllowed = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl = sortingAllowed = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if (rolloverEnabled || sortingAllowed || BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    int oldRolloverCol = BaseTableHeaderUI.this.rolloverCol;
                    BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(e2.getX());
                    BaseTableHeaderUI.this.updateRolloverColumn(oldRolloverCol, BaseTableHeaderUI.this.rolloverCol);
                }
            }

            public void mouseExited(MouseEvent e2) {
                if (BaseTableHeaderUI.this.header == null || BaseTableHeaderUI.this.header.getTable() == null) {
                    return;
                }
                boolean rolloverEnabled = Boolean.TRUE.equals(BaseTableHeaderUI.this.header.getClientProperty("rolloverEnabled"));
                boolean sortingAllowed = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl = sortingAllowed = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if (rolloverEnabled || sortingAllowed || BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    int oldRolloverCol = BaseTableHeaderUI.this.rolloverCol;
                    BaseTableHeaderUI.this.rolloverCol = -1;
                    BaseTableHeaderUI.this.updateRolloverColumn(oldRolloverCol, BaseTableHeaderUI.this.rolloverCol);
                }
            }
        };
        this.myMouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e2) {
                if (BaseTableHeaderUI.this.header == null || BaseTableHeaderUI.this.header.getTable() == null) {
                    return;
                }
                boolean rolloverEnabled = Boolean.TRUE.equals(BaseTableHeaderUI.this.header.getClientProperty("rolloverEnabled"));
                boolean sortingAllowed = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl = sortingAllowed = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if ((rolloverEnabled || sortingAllowed || BaseTableHeaderUI.this.header.getReorderingAllowed()) && BaseTableHeaderUI.this.header.getDraggedColumn() == null) {
                    int oldRolloverCol = BaseTableHeaderUI.this.rolloverCol;
                    BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(e2.getX());
                    BaseTableHeaderUI.this.updateRolloverColumn(oldRolloverCol, BaseTableHeaderUI.this.rolloverCol);
                }
            }

            public void mouseDragged(MouseEvent e2) {
                if (BaseTableHeaderUI.this.header == null || BaseTableHeaderUI.this.header.getTable() == null) {
                    return;
                }
                boolean rolloverEnabled = Boolean.TRUE.equals(BaseTableHeaderUI.this.header.getClientProperty("rolloverEnabled"));
                boolean sortingAllowed = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl = sortingAllowed = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if (rolloverEnabled || sortingAllowed || BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    if (BaseTableHeaderUI.this.header.getDraggedColumn() != null && BaseTableHeaderUI.this.header.getDraggedColumn().getIdentifier() != null) {
                        BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndex(BaseTableHeaderUI.this.header.getDraggedColumn().getIdentifier());
                    } else if (BaseTableHeaderUI.this.header.getResizingColumn() != null) {
                        BaseTableHeaderUI.this.rolloverCol = -1;
                    }
                }
            }
        };
        this.header.addMouseListener(this.myMouseAdapter);
        this.header.addMouseMotionListener(this.myMouseMotionAdapter);
    }

    public void uninstallListeners() {
        this.header.removeMouseListener(this.myMouseAdapter);
        this.header.removeMouseMotionListener(this.myMouseMotionAdapter);
        super.uninstallListeners();
    }

    protected boolean drawAllwaysActive() {
        return false;
    }

    protected boolean drawRolloverBar() {
        return false;
    }

    protected Component getHeaderRenderer(int col) {
        if (this.header == null || this.header.getTable() == null) {
            return null;
        }
        TableColumn tabCol = this.header.getColumnModel().getColumn(col);
        TableCellRenderer renderer = tabCol.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), tabCol.getHeaderValue(), false, false, -1, col);
    }

    private int getHeaderHeight() {
        if (this.header == null || this.header.getTable() == null) {
            return 0;
        }
        int height = 0;
        boolean accomodatedDefault = false;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            Object headerValue;
            boolean isDefault;
            TableColumn aColumn = columnModel.getColumn(column);
            boolean bl = isDefault = aColumn.getHeaderRenderer() == null;
            if (isDefault && accomodatedDefault) continue;
            Component comp = this.getHeaderRenderer(column);
            int rendererHeight = comp.getPreferredSize().height;
            height = Math.max(height, rendererHeight);
            if (!isDefault || rendererHeight <= 0 || (headerValue = aColumn.getHeaderValue()) == null || (headerValue = headerValue.toString()) == null || headerValue.equals("")) continue;
            accomodatedDefault = true;
        }
        return height + 2;
    }

    public Dimension getPreferredSize(JComponent c2) {
        if (this.header == null || this.header.getTable() == null) {
            return new Dimension(0, 0);
        }
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    protected void updateRolloverColumn(int oldColumn, int newColumn) {
        if (this.header == null || this.header.getTable() == null) {
            return;
        }
        this.header.repaint(this.header.getHeaderRect(oldColumn));
        this.header.repaint(this.header.getHeaderRect(newColumn));
    }

    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
    }

    public void paint(Graphics g2, JComponent c2) {
        int column;
        if (this.header == null || this.header.getTable() == null || this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g2.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g2, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g2, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g2.setColor(this.header.getParent().getBackground());
            g2.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g2.setColor(this.header.getBackground());
            g2.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g2, draggedCellRect, draggedColumnIndex);
        }
        this.rendererPane.removeAll();
    }

    protected void paintBackground(Graphics g2, Rectangle cellRect, int col) {
        Component component = this.getHeaderRenderer(col);
        int x2 = cellRect.x;
        int y2 = cellRect.y;
        int w2 = cellRect.width;
        int h2 = cellRect.height;
        if (col == this.rolloverCol && component != null && component.isEnabled()) {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getRolloverColors(), x2, y2, w2, h2);
        } else if (this.drawAllwaysActive() || JTattooUtilities.isFrameActive(this.header)) {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getColHeaderColors(), x2, y2, w2, h2);
        } else {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getInActiveColors(), x2, y2, w2, h2);
        }
    }

    protected void paintCell(Graphics g2, Rectangle cellRect, int col) {
        if (this.header == null || this.header.getTable() == null) {
            return;
        }
        Component component = this.getHeaderRenderer(col);
        if (!(component instanceof BaseDefaultHeaderRenderer)) {
            this.paintBackground(g2, cellRect, col);
        }
        this.rendererPane.paintComponent(g2, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        if (this.header == null || this.header.getTable() == null) {
            return -1;
        }
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private class MyRenderComponent
    extends JLabel {
        private JTable table = null;
        private int col = 0;
        private int gv = 0;

        public MyRenderComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.table = table;
            this.col = col;
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            this.setOpaque(false);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(10);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            if (JTattooUtilities.getJavaVersion() >= 1.6 && UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
                RowSorter.SortKey sortKey;
                List<RowSorter.SortKey> keyList;
                RowSorter<? extends TableModel> rowSorter = table == null ? null : table.getRowSorter();
                List<RowSorter.SortKey> list = keyList = rowSorter == null ? null : rowSorter.getSortKeys();
                if (keyList != null && keyList.size() > 0 && (sortKey = keyList.get(0)).getColumn() == table.convertColumnIndexToModel(col)) {
                    AbstractIconFactory iconFactory = ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory();
                    if (sortKey.getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                        this.setIcon(iconFactory.getUpArrowIcon());
                    } else if (sortKey.getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                        this.setIcon(iconFactory.getDownArrowIcon());
                    }
                }
            }
            this.gv = ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getRolloverColor());
        }

        protected void paintBackground(Graphics g2) {
            int draggedColumn = -1;
            if (BaseTableHeaderUI.this.header != null && BaseTableHeaderUI.this.header.getTable() != null && BaseTableHeaderUI.this.header.getDraggedColumn() != null) {
                draggedColumn = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndex(BaseTableHeaderUI.this.header.getDraggedColumn().getIdentifier());
            }
            if (this.table != null && this.table.isEnabled() && (this.col == BaseTableHeaderUI.this.rolloverCol || this.col == draggedColumn)) {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getRolloverColors(), 0, 0, this.getWidth(), this.getHeight());
                if (BaseTableHeaderUI.this.drawRolloverBar()) {
                    g2.setColor(AbstractLookAndFeel.getFocusColor());
                    g2.drawLine(0, 0, this.getWidth() - 1, 0);
                    g2.drawLine(0, 1, this.getWidth() - 1, 1);
                    g2.drawLine(0, 2, this.getWidth() - 1, 2);
                }
            } else if (BaseTableHeaderUI.this.drawAllwaysActive() || JTattooUtilities.isFrameActive(BaseTableHeaderUI.this.header)) {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getColHeaderColors(), 0, 0, this.getWidth(), this.getHeight());
            } else {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getInActiveColors(), 0, 0, this.getWidth(), this.getHeight());
            }
        }

        public void paint(Graphics g2) {
            this.paintBackground(g2);
            if (BaseTableHeaderUI.this.rolloverCol == this.col) {
                if (this.gv > 128) {
                    this.setForeground(Color.black);
                } else {
                    this.setForeground(Color.white);
                }
            }
            super.paint(g2);
        }
    }

    private class BaseDefaultHeaderRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new MyRenderComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

