/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BaseScrollBarUI
extends BasicScrollBarUI {
    protected int scrollBarWidth = 17;
    protected int incrGap = 0;
    protected int decrGap = 0;
    protected boolean isRollover = false;
    protected boolean isSquareButtons = false;

    public static ComponentUI createUI(JComponent c2) {
        return new BaseScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.scrollBarWidth = UIManager.getInt("ScrollBar.width");
        this.isSquareButtons = UIManager.getBoolean("ScrollBar.squareButtons");
        this.incrGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        this.decrGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        String scaleKey = (String)this.scrollbar.getClientProperty("JComponent.sizeVariant");
        if (scaleKey != null) {
            if ("large".equals(scaleKey)) {
                this.scrollBarWidth = (int)((double)this.scrollBarWidth * 1.15);
                this.incrGap = (int)((double)this.incrGap * 1.15);
                this.decrGap = (int)((double)this.decrGap * 1.15);
            } else if ("small".equals(scaleKey)) {
                this.scrollBarWidth = (int)((double)this.scrollBarWidth * 0.857);
                this.incrGap = (int)((double)this.incrGap * 0.857);
                this.decrGap = (int)((double)this.decrGap * 0.857);
            } else if ("mini".equals(scaleKey)) {
                this.scrollBarWidth = (int)((double)this.scrollBarWidth * 0.714);
                this.incrGap = (int)((double)this.incrGap * 0.714);
                this.decrGap = (int)((double)this.decrGap * 0.714);
            }
        }
    }

    protected JButton createDecreaseButton(int orientation) {
        return new BaseScrollButton(orientation, this.scrollBarWidth);
    }

    protected JButton createIncreaseButton(int orientation) {
        return new BaseScrollButton(orientation, this.scrollBarWidth);
    }

    public BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    public Dimension getPreferredSize(JComponent c2) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 16);
        }
        return new Dimension(this.scrollBarWidth * 3 + 16, this.scrollBarWidth);
    }

    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    protected void paintTrack(Graphics g2, JComponent c2, Rectangle trackBounds) {
        int w2 = c2.getWidth();
        int h2 = c2.getHeight();
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(g2, AbstractLookAndFeel.getTheme().getTrackColors(), 0, 0, w2, h2);
        } else {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getTrackColors(), 0, 0, w2, h2);
        }
    }

    protected Color[] getThumbColors() {
        if (this.isRollover || this.isDragging) {
            return AbstractLookAndFeel.getTheme().getRolloverColors();
        }
        if (!JTattooUtilities.isActive(this.scrollbar)) {
            return AbstractLookAndFeel.getTheme().getInActiveColors();
        }
        return AbstractLookAndFeel.getTheme().getThumbColors();
    }

    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        g2.translate(thumbBounds.x, thumbBounds.y);
        Color[] colors = this.getThumbColors();
        Color frameColorHi = ColorHelper.brighter(colors[1], 20.0);
        Color frameColorLo = ColorHelper.darker(colors[colors.length - 1], 10.0);
        Graphics2D g2D = (Graphics2D)g2;
        Composite savedComposite = g2D.getComposite();
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(g2, colors, 1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
            JTattooUtilities.draw3DBorder(g2, frameColorLo, ColorHelper.darker(frameColorLo, 15.0), 0, 0, thumbBounds.width, thumbBounds.height);
            g2D.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g2.setColor(frameColorHi);
            g2.drawLine(1, 1, thumbBounds.width - 2, 1);
            g2.drawLine(1, 1, 1, thumbBounds.height - 2);
            int dx = 5;
            int dy = thumbBounds.height / 2 - 3;
            int dw = thumbBounds.width - 11;
            Color c1 = Color.white;
            Color c22 = Color.darkGray;
            for (int i2 = 0; i2 < 4; ++i2) {
                g2.setColor(c1);
                g2.drawLine(dx, dy, dx + dw, dy);
                g2.setColor(c22);
                g2.drawLine(dx, ++dy, dx + dw, dy);
                ++dy;
            }
            g2D.setComposite(savedComposite);
        } else {
            JTattooUtilities.fillHorGradient(g2, colors, 1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
            JTattooUtilities.draw3DBorder(g2, frameColorLo, ColorHelper.darker(frameColorLo, 10.0), 0, 0, thumbBounds.width, thumbBounds.height);
            g2D.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g2.setColor(frameColorHi);
            g2.drawLine(1, 1, thumbBounds.width - 2, 1);
            g2.drawLine(1, 1, 1, thumbBounds.height - 2);
            int dx = thumbBounds.width / 2 - 3;
            int dy = 5;
            int dh = thumbBounds.height - 11;
            Color c1 = Color.white;
            Color c23 = Color.darkGray;
            for (int i3 = 0; i3 < 4; ++i3) {
                g2.setColor(c1);
                g2.drawLine(dx, dy, dx, dy + dh);
                g2.setColor(c23);
                g2.drawLine(++dx, dy, dx, dy + dh);
                ++dx;
            }
        }
        g2D.setComposite(savedComposite);
        g2.translate(-thumbBounds.x, -thumbBounds.y);
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        if (AbstractLookAndFeel.getTheme().isLinuxStyleScrollBarOn()) {
            Dimension sbSize = sb.getSize();
            Insets sbInsets = sb.getInsets();
            int sizeH = sbSize.height - sbInsets.top - sbInsets.bottom;
            int itemX = sbInsets.left;
            int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
            int itemH = Math.min(itemW, sizeH / 2);
            int decrButtonY = sbSize.height - sbInsets.bottom - itemH - itemH + 1;
            int incrButtonY = sbSize.height - sbInsets.bottom - itemH;
            float trackH = sbSize.height - sbInsets.top - sbInsets.bottom - itemW - itemW + 1;
            float min = sb.getMinimum();
            float max = sb.getMaximum();
            float extent = sb.getVisibleAmount();
            float range = max - min;
            float value = sb.getValue();
            int maxThumbH = this.getMaximumThumbSize().height;
            int minThumbH = this.getMinimumThumbSize().height;
            int thumbH = range <= 0.0f ? maxThumbH : (int)(trackH * (extent / range));
            thumbH = Math.max(thumbH, minThumbH);
            thumbH = Math.min(thumbH, maxThumbH);
            int thumbY = decrButtonY - thumbH;
            if (value < max - extent) {
                float thumbRange = trackH - (float)thumbH;
                thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            }
            if ((float)thumbH > trackH) {
                this.setThumbBounds(0, 0, 0, 0);
            } else {
                this.setThumbBounds(itemX, thumbY, itemW, thumbH);
            }
            this.decrButton.setBounds(itemX, decrButtonY, itemW, itemH);
            this.incrButton.setBounds(itemX, incrButtonY, itemW, itemH);
            this.trackRect.setBounds(itemX, 0, itemW, (int)trackH);
        } else {
            super.layoutVScrollbar(sb);
        }
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        if (AbstractLookAndFeel.getTheme().isLinuxStyleScrollBarOn()) {
            Dimension sbSize = sb.getSize();
            Insets sbInsets = sb.getInsets();
            int sizeW = sbSize.width - sbInsets.left - sbInsets.right;
            int itemY = sbInsets.top;
            int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
            int itemW = Math.min(itemH, sizeW / 2);
            int decrButtonX = sbSize.width - sbInsets.right - itemW - itemW + 1;
            int incrButtonX = sbSize.width - sbInsets.right - itemW;
            float trackW = sbSize.width - sbInsets.left - sbInsets.right - itemH - itemH + 1;
            float min = sb.getMinimum();
            float max = sb.getMaximum();
            float extent = sb.getVisibleAmount();
            float range = max - min;
            float value = sb.getValue();
            int maxThumbW = this.getMaximumThumbSize().width;
            int minThumbW = this.getMinimumThumbSize().width;
            int thumbW = range <= 0.0f ? maxThumbW : (int)(trackW * (extent / range));
            thumbW = Math.max(thumbW, minThumbW);
            thumbW = Math.min(thumbW, maxThumbW);
            int thumbX = decrButtonX - thumbW;
            if (value < max - extent) {
                float thumbRange = trackW - (float)thumbW;
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            }
            if ((float)thumbW > trackW) {
                this.setThumbBounds(0, 0, 0, 0);
            } else {
                this.setThumbBounds(thumbX, itemY, thumbW, itemH);
            }
            this.decrButton.setBounds(decrButtonX, itemY, itemW, itemH);
            this.incrButton.setBounds(incrButtonX, itemY, itemW, itemH);
            this.trackRect.setBounds(0, itemY, (int)trackW, itemH);
        } else {
            super.layoutHScrollbar(sb);
        }
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(BaseScrollBarUI.this);
        }

        public void mouseEntered(MouseEvent e2) {
            super.mouseEntered(e2);
            BaseScrollBarUI.this.isRollover = true;
            Rectangle r2 = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(r2.x, r2.y, r2.width, r2.height);
        }

        public void mouseExited(MouseEvent e2) {
            super.mouseExited(e2);
            BaseScrollBarUI.this.isRollover = false;
            Rectangle r2 = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(r2.x, r2.y, r2.width, r2.height);
        }

        public void mousePressed(MouseEvent e2) {
            super.mousePressed(e2);
            Rectangle r2 = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(r2.x, r2.y, r2.width, r2.height);
        }

        public void mouseReleased(MouseEvent e2) {
            super.mouseReleased(e2);
            Rectangle r2 = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(r2.x, r2.y, r2.width, r2.height);
        }
    }
}

