/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class BaseRadioButtonUI
extends BasicRadioButtonUI {
    private static BaseRadioButtonUI radioButtonUI = null;
    protected static Dimension size = new Dimension();
    protected static Rectangle viewRect = new Rectangle();
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();

    public static ComponentUI createUI(JComponent c2) {
        if (radioButtonUI == null) {
            radioButtonUI = new BaseRadioButtonUI();
        }
        return radioButtonUI;
    }

    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        b2.setRolloverEnabled(true);
        this.icon = UIManager.getIcon("RadioButton.icon");
    }

    public void paint(Graphics g2, JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        Font f2 = c2.getFont();
        g2.setFont(f2);
        FontMetrics fm = g2.getFontMetrics();
        Insets i2 = c2.getInsets();
        size = b2.getSize(size);
        BaseRadioButtonUI.viewRect.x = i2.left;
        BaseRadioButtonUI.viewRect.y = i2.top;
        BaseRadioButtonUI.viewRect.width = BaseRadioButtonUI.size.width - (i2.right + BaseRadioButtonUI.viewRect.x);
        BaseRadioButtonUI.viewRect.height = BaseRadioButtonUI.size.height - (i2.bottom + BaseRadioButtonUI.viewRect.y);
        BaseRadioButtonUI.iconRect.height = 0;
        BaseRadioButtonUI.iconRect.width = 0;
        BaseRadioButtonUI.iconRect.y = 0;
        BaseRadioButtonUI.iconRect.x = 0;
        BaseRadioButtonUI.textRect.height = 0;
        BaseRadioButtonUI.textRect.width = 0;
        BaseRadioButtonUI.textRect.y = 0;
        BaseRadioButtonUI.textRect.x = 0;
        Icon altIcon = b2.getIcon();
        int iconTextGap = this.getDefaultTextIconGap(b2);
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            iconTextGap = b2.getIconTextGap();
        }
        String text = SwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, iconTextGap);
        if (c2.isOpaque()) {
            this.paintBackground(g2, c2);
        }
        this.paintIcon(g2, c2, iconRect);
        if (text != null) {
            this.paintText(g2, c2, text, textRect);
        }
        if (b2.hasFocus() && b2.isFocusPainted() && BaseRadioButtonUI.textRect.width > 0 && BaseRadioButtonUI.textRect.height > 0) {
            this.paintFocus(g2, textRect, size);
        }
    }

    protected void paintBackground(Graphics g2, JComponent c2) {
        g2.setColor(c2.getBackground());
        g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
    }

    protected void paintIcon(Graphics g2, JComponent c2, Rectangle iconRect) {
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        Icon ico = null;
        ico = !model.isEnabled() ? (b2.isSelected() ? b2.getDisabledSelectedIcon() : b2.getDisabledIcon()) : (model.isPressed() ? b2.getPressedIcon() : (model.isRollover() ? (b2.isSelected() ? b2.getRolloverSelectedIcon() : b2.getRolloverIcon()) : (b2.isSelected() ? b2.getSelectedIcon() : b2.getIcon())));
        if (ico != null) {
            ico.paintIcon(c2, g2, iconRect.x, iconRect.y - 1);
        } else if (b2.getIcon() != null) {
            b2.getIcon().paintIcon(c2, g2, iconRect.x, iconRect.y - 1);
        } else {
            this.getDefaultIcon().paintIcon(c2, g2, iconRect.x, iconRect.y - 1);
        }
    }

    protected void paintText(Graphics g2, JComponent c2, String text, Rectangle textRect) {
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            Graphics2D g2D = (Graphics2D)g2;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v2.paint(g2, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            AbstractButton b2 = (AbstractButton)c2;
            ButtonModel model = b2.getModel();
            Font f2 = c2.getFont();
            g2.setFont(f2);
            FontMetrics fm = g2.getFontMetrics();
            int mnemIndex = -1;
            mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b2.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b2.getText(), model.getMnemonic());
            if (model.isEnabled()) {
                g2.setColor(b2.getForeground());
                JTattooUtilities.drawStringUnderlineCharAt(c2, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g2.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(c2, g2, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
                g2.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                JTattooUtilities.drawStringUnderlineCharAt(c2, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    protected void paintFocus(Graphics g2, Rectangle t2, Dimension d2) {
        g2.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g2, t2.x, t2.y - 1, t2.width + 1, t2.height + 1);
    }
}

