/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class BaseProgressBarUI
extends BasicProgressBarUI {
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c2) {
        return new BaseProgressBarUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.setBorder(UIManager.getBorder("ProgressBar.border"));
        this.propertyChangeListener = new PropertyChangeHandler();
        c2.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent c2) {
        c2.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallUI(c2);
    }

    protected Color getSelectionForeground() {
        Object selectionForeground = this.progressBar.getClientProperty("selectionForeground");
        if (selectionForeground instanceof Color) {
            return (Color)selectionForeground;
        }
        return super.getSelectionForeground();
    }

    protected Color getSelectionBackground() {
        Object selectionBackground = this.progressBar.getClientProperty("selectionBackground");
        if (selectionBackground instanceof Color) {
            return (Color)selectionBackground;
        }
        return super.getSelectionBackground();
    }

    protected void paintIndeterminate(Graphics g2, JComponent c2) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g2;
        Insets b2 = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b2.right + b2.left);
        int barRectHeight = this.progressBar.getHeight() - (b2.top + b2.bottom);
        Color[] colors = null;
        if (this.progressBar.getForeground() instanceof UIResource) {
            colors = !JTattooUtilities.isActive(c2) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (c2.isEnabled() ? AbstractLookAndFeel.getTheme().getProgressBarColors() : AbstractLookAndFeel.getTheme().getDisabledColors());
        } else {
            Color hiColor = ColorHelper.brighter(this.progressBar.getForeground(), 40.0);
            Color loColor = ColorHelper.darker(this.progressBar.getForeground(), 20.0);
            colors = ColorHelper.createColorArr(hiColor, loColor, 20);
        }
        Color cHi = ColorHelper.darker(colors[colors.length - 1], 5.0);
        Color cLo = ColorHelper.darker(colors[colors.length - 1], 10.0);
        Rectangle box = this.getBox(null);
        if (box != null) {
            g2D.setColor(this.progressBar.getForeground());
            JTattooUtilities.draw3DBorder(g2, cHi, cLo, box.x + 1, box.y + 1, box.width - 2, box.height - 2);
            if (this.progressBar.getOrientation() == 0) {
                JTattooUtilities.fillHorGradient(g2, colors, box.x + 2, box.y + 2, box.width - 4, box.height - 4);
            } else {
                JTattooUtilities.fillVerGradient(g2, colors, box.x + 2, box.y + 2, box.width - 4, box.height - 4);
            }
        }
        if (this.progressBar.isStringPainted()) {
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2D, b2.left, b2.top, barRectWidth, barRectHeight, box.width, b2);
            } else {
                this.paintString(g2D, b2.left, b2.top, barRectWidth, barRectHeight, box.height, b2);
            }
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        }
    }

    protected void paintDeterminate(Graphics g2, JComponent c2) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g2;
        Insets b2 = this.progressBar.getInsets();
        int w2 = this.progressBar.getWidth() - (b2.right + b2.left);
        int h2 = this.progressBar.getHeight() - (b2.top + b2.bottom);
        int amountFull = this.getAmountFull(b2, w2, h2);
        Color[] colors = null;
        if (this.progressBar.getForeground() instanceof UIResource) {
            colors = !JTattooUtilities.isActive(c2) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (c2.isEnabled() ? AbstractLookAndFeel.getTheme().getProgressBarColors() : AbstractLookAndFeel.getTheme().getDisabledColors());
        } else {
            Color hiColor = ColorHelper.brighter(this.progressBar.getForeground(), 40.0);
            Color loColor = ColorHelper.darker(this.progressBar.getForeground(), 20.0);
            colors = ColorHelper.createColorArr(hiColor, loColor, 20);
        }
        Color cHi = ColorHelper.darker(colors[colors.length - 1], 5.0);
        Color cLo = ColorHelper.darker(colors[colors.length - 1], 10.0);
        if (this.progressBar.getOrientation() == 0) {
            if (JTattooUtilities.isLeftToRight(this.progressBar)) {
                JTattooUtilities.draw3DBorder(g2, cHi, cLo, 2, 2, amountFull - 2, h2 - 2);
                JTattooUtilities.fillHorGradient(g2, colors, 3, 3, amountFull - 4, h2 - 4);
            } else {
                JTattooUtilities.draw3DBorder(g2, cHi, cLo, w2 - amountFull + 2, 2, w2 - 2, h2 - 2);
                JTattooUtilities.fillHorGradient(g2, colors, w2 - amountFull + 3, 3, w2 - 4, h2 - 4);
            }
        } else {
            JTattooUtilities.draw3DBorder(g2, cHi, cLo, 2, h2 - amountFull + 2, w2 - 2, amountFull - 2);
            JTattooUtilities.fillVerGradient(g2, colors, 3, h2 - amountFull + 3, w2 - 4, amountFull - 4);
        }
        if (this.progressBar.isStringPainted()) {
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            this.paintString(g2, b2.left, b2.top, w2, h2, amountFull, b2);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        }
    }

    public void paint(Graphics g2, JComponent c2) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            if (this.progressBar.isIndeterminate()) {
                this.paintIndeterminate(g2, c2);
            } else {
                this.paintDeterminate(g2, c2);
            }
        } else {
            this.paintDeterminate(g2, c2);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e2) {
            if ("selectionForeground".equals(e2.getPropertyName()) && e2.getNewValue() instanceof Color) {
                BaseProgressBarUI.this.progressBar.invalidate();
                BaseProgressBarUI.this.progressBar.repaint();
            } else if ("selectionBackground".equals(e2.getPropertyName()) && e2.getNewValue() instanceof Color) {
                BaseProgressBarUI.this.progressBar.invalidate();
                BaseProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

