/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class BasePopupMenuUI
extends BasicPopupMenuUI {
    protected static Robot robot = null;
    protected BufferedImage screenImage = null;
    protected MyPopupMenuListener myPopupListener = null;

    public static ComponentUI createUI(JComponent c2) {
        return new BasePopupMenuUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.setOpaque(false);
    }

    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        c2.setOpaque(true);
    }

    public void installListeners() {
        super.installListeners();
        if (!this.isMenuOpaque()) {
            this.myPopupListener = new MyPopupMenuListener(this);
            this.popupMenu.addPopupMenuListener(this.myPopupListener);
        }
    }

    public void uninstallListeners() {
        if (!this.isMenuOpaque()) {
            this.popupMenu.removePopupMenuListener(this.myPopupListener);
        }
        super.uninstallListeners();
    }

    private boolean isMenuOpaque() {
        return AbstractLookAndFeel.getTheme().isMenuOpaque() || this.getRobot() == null;
    }

    private Robot getRobot() {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return robot;
    }

    public Popup getPopup(JPopupMenu popupMenu, int x2, int y2) {
        if (!this.isMenuOpaque()) {
            try {
                Dimension size = popupMenu.getPreferredSize();
                Rectangle screenRect = new Rectangle(x2, y2, size.width, size.height);
                this.screenImage = this.getRobot().createScreenCapture(screenRect);
            }
            catch (Exception ex) {
                this.screenImage = null;
            }
        }
        return super.getPopup(popupMenu, x2, y2);
    }

    private void resetScreenImage() {
        this.screenImage = null;
    }

    public void update(Graphics g2, JComponent c2) {
        if (this.screenImage != null) {
            g2.drawImage(this.screenImage, 0, 0, null);
        } else {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
        }
    }

    public static class MyPopupMenuListener
    implements PopupMenuListener {
        private BasePopupMenuUI popupMenuUI = null;

        public MyPopupMenuListener(BasePopupMenuUI aPopupMenuUI) {
            this.popupMenuUI = aPopupMenuUI;
        }

        public void popupMenuCanceled(PopupMenuEvent e2) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
            if (this.popupMenuUI.screenImage != null) {
                JPopupMenu popup = (JPopupMenu)e2.getSource();
                JRootPane root = popup.getRootPane();
                if (popup.isShowing() && root.isShowing()) {
                    Point ptPopup = popup.getLocationOnScreen();
                    Point ptRoot = root.getLocationOnScreen();
                    Graphics g2 = popup.getRootPane().getGraphics();
                    g2.drawImage(this.popupMenuUI.screenImage, ptPopup.x - ptRoot.x, ptPopup.y - ptRoot.y, null);
                    this.popupMenuUI.resetScreenImage();
                }
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        }
    }
}

