/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class BaseMenuUI
extends BasicMenuUI {
    protected boolean paintRolloverBorder = true;

    public static ComponentUI createUI(JComponent c2) {
        return new BaseMenuUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.setOpaque(false);
    }

    public void uninstallUI(JComponent c2) {
        c2.setOpaque(true);
        super.uninstallUI(c2);
    }

    public void update(Graphics g2, JComponent c2) {
        this.paintBackground(g2, c2, 0, 0, c2.getWidth(), c2.getHeight());
        this.paint(g2, c2);
    }

    protected void installDefaults() {
        super.installDefaults();
        Boolean isRolloverEnabled = (Boolean)UIManager.get("MenuBar.rolloverEnabled");
        if (isRolloverEnabled.booleanValue()) {
            this.menuItem.setRolloverEnabled(true);
        }
    }

    protected void paintBackground(Graphics g2, JMenuItem menuItem, Color bgColor) {
        if (menuItem.isOpaque()) {
            int w2 = menuItem.getWidth();
            int h2 = menuItem.getHeight();
            this.paintBackground(g2, menuItem, 0, 0, w2, h2);
        }
    }

    protected void paintBackground(Graphics g2, JComponent c2, int x2, int y2, int w2, int h2) {
        JMenuItem mi = (JMenuItem)c2;
        ButtonModel model = mi.getModel();
        if (c2.getParent() instanceof JMenuBar) {
            if (model.isRollover() || model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                Color backColor = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
                if (model.isRollover()) {
                    backColor = ColorHelper.brighter(backColor, 10.0);
                }
                g2.setColor(backColor);
                g2.fillRect(x2, y2, w2, h2);
                if (this.paintRolloverBorder && model.isRollover() && !model.isSelected()) {
                    backColor = ColorHelper.darker(backColor, 20.0);
                    g2.setColor(backColor);
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                }
            }
        } else if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
            g2.setColor(AbstractLookAndFeel.getMenuSelectionBackgroundColor());
            g2.fillRect(x2, y2, w2, h2);
        } else if (!AbstractLookAndFeel.getTheme().isMenuOpaque()) {
            Graphics2D g2D = (Graphics2D)g2;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, AbstractLookAndFeel.getTheme().getMenuAlpha());
            g2D.setComposite(alpha);
            g2.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            g2.fillRect(x2, y2, w2, h2);
            g2D.setComposite(savedComposite);
        } else {
            g2.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            g2.fillRect(x2, y2, w2, h2);
        }
        if (this.menuItem.isSelected() && this.menuItem.isArmed()) {
            g2.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getMenuForegroundColor());
        }
    }

    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        Graphics2D g2D = (Graphics2D)g2;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        g2.setColor(AbstractLookAndFeel.getMenuForegroundColor());
        if (menuItem.getParent() instanceof JMenuBar) {
            if (model.isRollover() || model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g2.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
            }
        } else if (menuItem.isSelected() && menuItem.isArmed()) {
            g2.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        }
        super.paintText(g2, menuItem, textRect, text);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c2) {
        if (JTattooUtilities.getJavaVersion() >= 1.5) {
            return new MyMouseInputHandler();
        }
        return super.createMouseInputListener(c2);
    }

    protected class MyMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected MyMouseInputHandler() {
            super(BaseMenuUI.this);
        }

        public void mouseEntered(MouseEvent evt) {
            super.mouseEntered(evt);
            JMenu menu = (JMenu)evt.getSource();
            if (menu.isTopLevelMenu() && menu.isRolloverEnabled()) {
                menu.getModel().setRollover(true);
                BaseMenuUI.this.menuItem.repaint();
            }
        }

        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            JMenu menu = (JMenu)evt.getSource();
            ButtonModel model = menu.getModel();
            if (menu.isRolloverEnabled()) {
                model.setRollover(false);
                BaseMenuUI.this.menuItem.repaint();
            }
        }
    }
}

