/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BaseMenuItemUI
extends BasicMenuItemUI {
    public static ComponentUI createUI(JComponent c2) {
        return new BaseMenuItemUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.setOpaque(false);
    }

    public void uninstallUI(JComponent c2) {
        c2.setOpaque(true);
        super.uninstallUI(c2);
    }

    public void update(Graphics g2, JComponent c2) {
        this.paintBackground(g2, c2, 0, 0, c2.getWidth(), c2.getHeight());
        this.paint(g2, c2);
    }

    protected void paintBackground(Graphics g2, JMenuItem menuItem, Color bgColor) {
        if (menuItem.isOpaque()) {
            int w2 = menuItem.getWidth();
            int h2 = menuItem.getHeight();
            this.paintBackground(g2, menuItem, 0, 0, w2, h2);
        }
    }

    protected void paintBackground(Graphics g2, JComponent c2, int x2, int y2, int w2, int h2) {
        JMenuItem b2 = (JMenuItem)c2;
        ButtonModel model = b2.getModel();
        if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
            g2.setColor(AbstractLookAndFeel.getMenuSelectionBackgroundColor());
            g2.fillRect(x2, y2, w2, h2);
        } else if (!AbstractLookAndFeel.getTheme().isMenuOpaque()) {
            Graphics2D g2D = (Graphics2D)g2;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, AbstractLookAndFeel.getTheme().getMenuAlpha());
            g2D.setComposite(alpha);
            g2.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            g2.fillRect(x2, y2, w2, h2);
            g2D.setComposite(savedComposite);
        } else {
            g2.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            g2.fillRect(x2, y2, w2, h2);
        }
        if (this.menuItem.isSelected() && this.menuItem.isArmed()) {
            g2.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getMenuForegroundColor());
        }
    }

    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text) {
        Graphics2D g2D = (Graphics2D)g2;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        if (menuItem.isSelected() && menuItem.isArmed()) {
            g2.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getMenuForegroundColor());
        }
        super.paintText(g2, menuItem, textRect, text);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }
}

