/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BaseBorders {
    protected static Border buttonBorder = null;
    protected static Border focusFrameBorder = null;
    protected static Border textFieldBorder = null;
    protected static Border spinnerBorder = null;
    protected static Border comboBoxBorder = null;
    protected static Border progressBarBorder = null;
    protected static Border tableHeaderBorder = null;
    protected static Border popupMenuBorder = null;
    protected static Border menuItemBorder = null;
    protected static Border toolBarBorder = null;
    protected static Border toolButtonBorder = null;
    protected static Border rolloverToolButtonBorder = null;
    protected static Border internalFrameBorder = null;
    protected static Border paletteBorder = null;
    protected static Border scrollPaneBorder = null;
    protected static Border tableScrollPaneBorder = null;
    protected static Border tabbedPaneBorder = null;
    protected static Border desktopIconBorder = null;

    public static void initDefaults() {
        buttonBorder = null;
        textFieldBorder = null;
        spinnerBorder = null;
        comboBoxBorder = null;
        progressBarBorder = null;
        tableHeaderBorder = null;
        popupMenuBorder = null;
        menuItemBorder = null;
        toolBarBorder = null;
        toolButtonBorder = null;
        rolloverToolButtonBorder = null;
        paletteBorder = null;
        internalFrameBorder = null;
        scrollPaneBorder = null;
        tableScrollPaneBorder = null;
        tabbedPaneBorder = null;
        desktopIconBorder = null;
    }

    public static Border getFocusFrameBorder() {
        if (focusFrameBorder == null) {
            focusFrameBorder = new FocusFrameBorder();
        }
        return focusFrameBorder;
    }

    public static Border getTextBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new TextFieldBorder();
        }
        return textFieldBorder;
    }

    public static Border getSpinnerBorder() {
        if (spinnerBorder == null) {
            spinnerBorder = new SpinnerBorder();
        }
        return spinnerBorder;
    }

    public static Border getTextFieldBorder() {
        return BaseBorders.getTextBorder();
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new ComboBoxBorder();
        }
        return comboBoxBorder;
    }

    public static Border getProgressBarBorder() {
        if (progressBarBorder == null) {
            progressBarBorder = BorderFactory.createLineBorder(ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 30.0));
        }
        return progressBarBorder;
    }

    public static Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new TableHeaderBorder();
        }
        return tableHeaderBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = AbstractLookAndFeel.getTheme().isMenuOpaque() ? new BasePopupMenuBorder() : new BasePopupMenuShadowBorder();
        }
        return popupMenuBorder;
    }

    public static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new MenuItemBorder();
        }
        return menuItemBorder;
    }

    public static Border getToolBarBorder() {
        if (toolBarBorder == null) {
            toolBarBorder = new ToolBarBorder();
        }
        return toolBarBorder;
    }

    public static Border getToolButtonBorder() {
        if (toolButtonBorder == null) {
            toolButtonBorder = new ToolButtonBorder();
        }
        return toolButtonBorder;
    }

    public static Border getMenuBarBorder() {
        return BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public static Border getPaletteBorder() {
        if (paletteBorder == null) {
            paletteBorder = new PaletteBorder();
        }
        return paletteBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder(false);
        }
        return scrollPaneBorder;
    }

    public static Border getTableScrollPaneBorder() {
        if (tableScrollPaneBorder == null) {
            tableScrollPaneBorder = new ScrollPaneBorder(true);
        }
        return tableScrollPaneBorder;
    }

    public static Border getTabbedPaneBorder() {
        if (tabbedPaneBorder == null) {
            tabbedPaneBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }
        return tabbedPaneBorder;
    }

    public static Border getDesktopIconBorder() {
        if (desktopIconBorder == null) {
            desktopIconBorder = new BorderUIResource.CompoundBorderUIResource(new LineBorder(AbstractLookAndFeel.getWindowBorderColor(), 1), new MatteBorder(2, 2, 1, 2, AbstractLookAndFeel.getWindowBorderColor()));
        }
        return desktopIconBorder;
    }

    public static class Down3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            ColorUIResource frameColor = AbstractLookAndFeel.getTheme().getBackgroundColor();
            JTattooUtilities.draw3DBorder(g2, ColorHelper.darker(frameColor, 20.0), ColorHelper.brighter(frameColor, 80.0), x2, y2, w2, h2);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(Down3DBorder.insets.top, Down3DBorder.insets.left, Down3DBorder.insets.bottom, Down3DBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = Down3DBorder.insets.left;
            borderInsets.top = Down3DBorder.insets.top;
            borderInsets.right = Down3DBorder.insets.right;
            borderInsets.bottom = Down3DBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class BaseInternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        protected final int dw = 5;
        protected final int trackWidth = 22;
        protected final Insets insets = new Insets(5, 5, 5, 5);
        protected final Insets paletteInsets = new Insets(3, 3, 3, 3);

        public boolean isResizable(Component c2) {
            boolean resizable = true;
            if (c2 instanceof JDialog) {
                JDialog dialog = (JDialog)c2;
                resizable = dialog.isResizable();
            } else if (c2 instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)c2;
                resizable = frame.isResizable();
            } else if (c2 instanceof JRootPane) {
                JRootPane jp = (JRootPane)c2;
                if (jp.getParent() instanceof JFrame) {
                    JFrame frame = (JFrame)c2.getParent();
                    resizable = frame.isResizable();
                } else if (jp.getParent() instanceof JDialog) {
                    JDialog dialog = (JDialog)c2.getParent();
                    resizable = dialog.isResizable();
                }
            }
            return resizable;
        }

        public boolean isActive(Component c2) {
            JRootPane jp;
            boolean active = true;
            if (c2 instanceof JDialog) {
                JDialog dlg = (JDialog)c2;
                if (dlg.getParent() instanceof JComponent) {
                    return JTattooUtilities.isActive((JComponent)dlg.getParent());
                }
            } else if (c2 instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)c2;
                active = frame.isSelected();
                if (active) {
                    return JTattooUtilities.isActive(frame);
                }
            } else if (c2 instanceof JRootPane && (jp = (JRootPane)c2).getTopLevelAncestor() instanceof Window) {
                Window window = (Window)jp.getTopLevelAncestor();
                return JTattooUtilities.isWindowActive(window);
            }
            return active;
        }

        public int getTitleHeight(Component c2) {
            int th = 21;
            int fh = this.getBorderInsets((Component)c2).top + this.getBorderInsets((Component)c2).bottom;
            if (c2 instanceof JDialog) {
                JDialog dialog = (JDialog)c2;
                th = dialog.getSize().height - dialog.getContentPane().getSize().height - fh - 1;
                if (dialog.getJMenuBar() != null) {
                    th -= dialog.getJMenuBar().getSize().height;
                }
            } else if (c2 instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)c2;
                th = frame.getSize().height - frame.getRootPane().getSize().height - fh - 1;
                if (frame.getJMenuBar() != null) {
                    th -= frame.getJMenuBar().getSize().height;
                }
            } else if (c2 instanceof JRootPane) {
                JRootPane jp = (JRootPane)c2;
                if (jp.getParent() instanceof JFrame) {
                    JFrame frame = (JFrame)c2.getParent();
                    th = frame.getSize().height - frame.getContentPane().getSize().height - fh - 1;
                    if (frame.getJMenuBar() != null) {
                        th -= frame.getJMenuBar().getSize().height;
                    }
                } else if (jp.getParent() instanceof JDialog) {
                    JDialog dialog = (JDialog)c2.getParent();
                    th = dialog.getSize().height - dialog.getContentPane().getSize().height - fh - 1;
                    if (dialog.getJMenuBar() != null) {
                        th -= dialog.getJMenuBar().getSize().height;
                    }
                }
            }
            return th;
        }

        public Insets getBorderInsets(Component c2) {
            if (this.isResizable(c2)) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            return new Insets(this.paletteInsets.top, this.paletteInsets.left, this.paletteInsets.bottom, this.paletteInsets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            Insets ins = this.getBorderInsets(c2);
            borderInsets.left = ins.left;
            borderInsets.top = ins.top;
            borderInsets.right = ins.right;
            borderInsets.bottom = ins.bottom;
            return borderInsets;
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            if (JTattooUtilities.isFrameActive((JComponent)c2)) {
                g2.setColor(AbstractLookAndFeel.getWindowBorderColor());
            } else {
                g2.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
            }
            g2.drawRect(x2, y2, w2 - 1, h2 - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(PaletteBorder.insets.top, PaletteBorder.insets.left, PaletteBorder.insets.bottom, PaletteBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = PaletteBorder.insets.left;
            borderInsets.top = PaletteBorder.insets.top;
            borderInsets.right = PaletteBorder.insets.right;
            borderInsets.bottom = PaletteBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class ToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            ColorUIResource frameColor = AbstractLookAndFeel.getToolbarBackgroundColor();
            Color frameHiColor = ColorHelper.brighter(frameColor, 10.0);
            Color frameLoColor = ColorHelper.darker(frameColor, 30.0);
            JTattooUtilities.draw3DBorder(g2, frameHiColor, frameLoColor, x2, y2, w2, h2);
            if (model.isPressed() && model.isArmed() || model.isSelected()) {
                JTattooUtilities.draw3DBorder(g2, frameLoColor, frameHiColor, x2, y2, w2, h2);
            } else {
                JTattooUtilities.draw3DBorder(g2, frameLoColor, frameHiColor, x2, y2, w2, h2);
                JTattooUtilities.draw3DBorder(g2, frameHiColor, frameLoColor, x2 + 1, y2 + 1, w2 - 2, h2 - 2);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(ToolButtonBorder.insets.top, ToolButtonBorder.insets.left, ToolButtonBorder.insets.bottom, ToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ToolButtonBorder.insets.left;
            borderInsets.top = ToolButtonBorder.insets.top;
            borderInsets.right = ToolButtonBorder.insets.right;
            borderInsets.bottom = ToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        private static final Color shadow = new Color(160, 160, 160);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            if (((JToolBar)c2).isFloatable()) {
                Graphics2D g2D = (Graphics2D)g2;
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                if (((JToolBar)c2).getOrientation() == 0) {
                    if (!JTattooUtilities.isLeftToRight(c2)) {
                        x2 += w2 - 15;
                    }
                    g2.setColor(Color.white);
                    g2.drawLine(x2 + 3, y2 + 4, x2 + 3, h2 - 5);
                    g2.drawLine(x2 + 6, y2 + 3, x2 + 6, h2 - 4);
                    g2.drawLine(x2 + 9, y2 + 4, x2 + 9, h2 - 5);
                    g2.setColor(shadow);
                    g2.drawLine(x2 + 4, y2 + 4, x2 + 4, h2 - 5);
                    g2.drawLine(x2 + 7, y2 + 3, x2 + 7, h2 - 4);
                    g2.drawLine(x2 + 10, y2 + 4, x2 + 10, h2 - 5);
                } else {
                    g2.setColor(Color.white);
                    g2.drawLine(x2 + 3, y2 + 3, w2 - 4, y2 + 3);
                    g2.drawLine(x2 + 3, y2 + 6, w2 - 4, y2 + 6);
                    g2.drawLine(x2 + 3, y2 + 9, w2 - 4, y2 + 9);
                    g2.setColor(shadow);
                    g2.drawLine(x2 + 3, y2 + 4, w2 - 4, y2 + 4);
                    g2.drawLine(x2 + 3, y2 + 7, w2 - 4, y2 + 7);
                    g2.drawLine(x2 + 3, y2 + 10, w2 - 4, y2 + 10);
                }
                g2D.setComposite(savedComposite);
            }
        }

        public Insets getBorderInsets(Component c2) {
            Insets margin;
            Insets insets = new Insets(2, 2, 2, 2);
            if (((JToolBar)c2).isFloatable()) {
                if (((JToolBar)c2).getOrientation() == 0) {
                    if (JTattooUtilities.isLeftToRight(c2)) {
                        insets.left = 15;
                    } else {
                        insets.right = 15;
                    }
                } else {
                    insets.top = 15;
                }
            }
            if ((margin = ((JToolBar)c2).getMargin()) != null) {
                insets.left += margin.left;
                insets.top += margin.top;
                insets.right += margin.right;
                insets.bottom += margin.bottom;
            }
            return insets;
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            Insets insets = this.getBorderInsets(c2);
            borderInsets.left = insets.left;
            borderInsets.top = insets.top;
            borderInsets.right = insets.right;
            borderInsets.bottom = insets.bottom;
            return borderInsets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            JMenuItem b2 = (JMenuItem)c2;
            ButtonModel model = b2.getModel();
            ColorUIResource borderColorLo = AbstractLookAndFeel.getFrameColor();
            Color borderColorHi = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 40.0);
            if (c2.getParent() instanceof JMenuBar) {
                if (model.isArmed() || model.isSelected()) {
                    g2.setColor(borderColorLo);
                    g2.drawLine(x2, y2, x2 + w2 - 1, y2);
                    g2.drawLine(x2, y2, x2, y2 + h2 - 1);
                    g2.drawLine(x2 + w2 - 1, y2 + 1, x2 + w2 - 1, y2 + h2 - 1);
                    g2.setColor(borderColorHi);
                    g2.drawLine(x2 + 1, y2 + 1, x2 + w2 - 2, y2 + 1);
                    g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + h2 - 1);
                }
            } else if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                g2.setColor(borderColorLo);
                g2.drawLine(x2, y2, x2 + w2 - 1, y2);
                g2.drawLine(x2, y2 + h2 - 1, x2 + w2 - 1, y2 + h2 - 1);
                g2.setColor(borderColorHi);
                g2.drawLine(x2, y2 + 1, x2 + w2 - 2, y2 + 1);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(MenuItemBorder.insets.top, MenuItemBorder.insets.left, MenuItemBorder.insets.bottom, MenuItemBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = MenuItemBorder.insets.left;
            borderInsets.top = MenuItemBorder.insets.top;
            borderInsets.right = MenuItemBorder.insets.right;
            borderInsets.bottom = MenuItemBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class BasePopupMenuShadowBorder
    extends BasePopupMenuBorder {
        public BasePopupMenuShadowBorder() {
            shadowSize = 4;
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            int dx;
            Graphics2D g2D = (Graphics2D)g2;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, AbstractLookAndFeel.getTheme().getMenuAlpha());
            g2D.setComposite(alpha);
            ColorUIResource logoColor = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
            ColorUIResource borderColorLo = AbstractLookAndFeel.getFrameColor();
            Color borderColorHi = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 40.0);
            g2.setColor(logoColor);
            if (JTattooUtilities.isLeftToRight(c2)) {
                dx = this.getBorderInsets((Component)c2).left;
                g2.fillRect(x2, y2, dx - 1, h2 - 1 - shadowSize);
                this.paintLogo(c2, g2, x2, y2, w2, h2);
                g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g2.drawLine(x2 + dx, y2 + 1, x2 + w2 - shadowSize - 2, y2 + 1);
                g2.setColor(borderColorHi);
                g2.drawLine(x2 + 1, y2, x2 + 1, y2 + h2 - shadowSize - 2);
                g2.setColor(borderColorLo);
                if (this.isMenuBarPopup(c2)) {
                    g2.drawLine(x2 + dx - 1, y2, x2 + w2 - shadowSize - 1, y2);
                    g2.drawLine(x2, y2, x2, y2 + h2 - shadowSize - 1);
                    g2.drawLine(x2, y2 + h2 - shadowSize - 1, x2 + w2 - shadowSize - 1, y2 + h2 - shadowSize - 1);
                    g2.drawLine(x2 + w2 - shadowSize - 1, y2 + 1, x2 + w2 - shadowSize - 1, y2 + h2 - shadowSize - 1);
                } else {
                    g2.drawRect(x2, y2, w2 - shadowSize - 1, h2 - shadowSize - 1);
                }
                g2.drawLine(x2 + dx - 1, y2 + 1, x2 + dx - 1, y2 + h2 - shadowSize - 1);
            } else {
                dx = this.getBorderInsets((Component)c2).right - shadowSize;
                g2.fillRect(x2 + w2 - dx - shadowSize, y2, dx - 1, h2 - 1 - shadowSize);
                this.paintLogo(c2, g2, x2, y2, w2, h2);
                g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g2.drawLine(x2 + 1, y2 + 1, x2 + w2 - dx - shadowSize - 1, y2 + 1);
                g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + h2 - shadowSize - 2);
                g2.setColor(borderColorLo);
                if (this.isMenuBarPopup(c2)) {
                    g2.drawLine(x2, y2, x2 + w2 - dx - shadowSize, y2);
                    g2.drawLine(x2, y2, x2, y2 + h2 - shadowSize - 1);
                    g2.drawLine(x2, y2 + h2 - shadowSize - 1, x2 + w2 - shadowSize - 1, y2 + h2 - shadowSize - 1);
                    g2.drawLine(x2 + w2 - shadowSize - 1, y2, x2 + w2 - shadowSize - 1, y2 + h2 - shadowSize - 1);
                } else {
                    g2.drawRect(x2, y2, w2 - shadowSize - 1, h2 - shadowSize - 1);
                }
                g2.drawLine(x2 + w2 - dx - shadowSize, y2 + 1, x2 + w2 - dx - shadowSize, y2 + h2 - shadowSize - 1);
            }
            g2D.setColor(AbstractLookAndFeel.getTheme().getShadowColor());
            float alphaValue = 0.4f;
            for (int i2 = 0; i2 < shadowSize; ++i2) {
                alpha = AlphaComposite.getInstance(3, alphaValue);
                g2D.setComposite(alpha);
                g2.drawLine(x2 + w2 - shadowSize + i2, y2 + shadowSize, x2 + w2 - shadowSize + i2, y2 + h2 - shadowSize - 1 + i2);
                g2.drawLine(x2 + shadowSize, y2 + h2 - shadowSize + i2, x2 + w2 - shadowSize + i2, y2 + h2 - shadowSize + i2);
                alphaValue -= alphaValue / 2.0f;
            }
            g2D.setComposite(savedComposite);
        }
    }

    public static class BasePopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Font logoFont;
        protected static Insets leftLogoInsets;
        protected static Insets rightLogoInsets;
        protected static Insets insets;
        protected static int shadowSize;

        public BasePopupMenuBorder() {
            logoFont = new Font("Dialog", 1, 12);
            leftLogoInsets = new Insets(2, 18, 1, 1);
            rightLogoInsets = new Insets(2, 2, 1, 18);
            insets = new Insets(2, 1, 1, 1);
            shadowSize = 0;
        }

        public boolean isMenuBarPopup(Component c2) {
            JPopupMenu pm;
            boolean menuBarPopup = false;
            if (c2 instanceof JPopupMenu && (pm = (JPopupMenu)c2).getInvoker() != null) {
                menuBarPopup = pm.getInvoker().getParent() instanceof JMenuBar;
            }
            return menuBarPopup;
        }

        public boolean hasLogo(Component c2) {
            return AbstractLookAndFeel.getTheme().getLogoString() != null && AbstractLookAndFeel.getTheme().getLogoString().length() > 0;
        }

        public Color getLogoColorHi() {
            return Color.white;
        }

        public Color getLogoColorLo() {
            return ColorHelper.darker(AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor(), 20.0);
        }

        public void paintLogo(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            if (this.hasLogo(c2)) {
                Graphics2D g2D = (Graphics2D)g2;
                Font savedFont = g2D.getFont();
                g2.setFont(logoFont);
                FontMetrics fm = g2D.getFontMetrics();
                String logo = JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fm, h2 - 16);
                AffineTransform savedTransform = g2D.getTransform();
                Color fc = this.getLogoColorHi();
                Color bc = this.getLogoColorLo();
                if (JTattooUtilities.isLeftToRight(c2)) {
                    g2D.translate(fm.getAscent() + 1, h2 - shadowSize - 4);
                    g2D.rotate(Math.toRadians(-90.0));
                    g2D.setColor(bc);
                    JTattooUtilities.drawString((JComponent)c2, g2, logo, 0, 1);
                    g2D.setColor(fc);
                    JTattooUtilities.drawString((JComponent)c2, g2, logo, 1, 0);
                } else {
                    g2D.translate(w2 - shadowSize - 4, h2 - shadowSize - 4);
                    g2D.rotate(Math.toRadians(-90.0));
                    g2D.setColor(bc);
                    JTattooUtilities.drawString((JComponent)c2, g2, logo, 0, 1);
                    g2D.setColor(fc);
                    JTattooUtilities.drawString((JComponent)c2, g2, logo, 1, 0);
                }
                g2D.setTransform(savedTransform);
                g2D.setFont(savedFont);
            }
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            ColorUIResource logoColor = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
            ColorUIResource borderColorLo = AbstractLookAndFeel.getFrameColor();
            Color borderColorHi = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 40.0);
            g2.setColor(logoColor);
            if (JTattooUtilities.isLeftToRight(c2)) {
                int dx = this.getBorderInsets((Component)c2).left;
                g2.fillRect(x2, y2, dx - 1, h2 - 1);
                this.paintLogo(c2, g2, x2, y2, w2, h2);
                g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g2.drawLine(x2 + dx, y2 + 1, x2 + w2 - 2, y2 + 1);
                g2.setColor(borderColorHi);
                g2.drawLine(x2 + 1, y2, x2 + 1, y2 + h2 - 2);
                g2.setColor(borderColorLo);
                if (this.isMenuBarPopup(c2)) {
                    g2.drawLine(x2 + dx - 1, y2, x2 + w2, y2);
                    g2.drawLine(x2, y2, x2, y2 + h2 - 1);
                    g2.drawLine(x2, y2 + h2 - 1, x2 + w2, y2 + h2 - 1);
                    g2.drawLine(x2 + w2 - 1, y2 + 1, x2 + w2 - 1, y2 + h2 - 1);
                } else {
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                }
                g2.drawLine(x2 + dx - 1, y2 + 1, x2 + dx - 1, y2 + h2 - 1);
            } else {
                int dx = this.getBorderInsets((Component)c2).right;
                g2.fillRect(x2 + w2 - dx, y2, dx, h2 - 1);
                this.paintLogo(c2, g2, x2, y2, w2, h2);
                g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g2.drawLine(x2 + 1, y2 + 1, x2 + w2 - dx - 1, y2 + 1);
                g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + h2 - 2);
                g2.setColor(borderColorLo);
                if (this.isMenuBarPopup(c2)) {
                    g2.drawLine(x2, y2, x2 + w2 - dx, y2);
                    g2.drawLine(x2, y2, x2, y2 + h2 - 1);
                    g2.drawLine(x2, y2 + h2 - 1, x2 + w2, y2 + h2 - 1);
                    g2.drawLine(x2 + w2 - 1, y2, x2 + w2 - 1, y2 + h2 - 1);
                } else {
                    g2.drawRect(x2, y2, w2 - 1, h2 - 1);
                }
                g2.drawLine(x2 + w2 - dx, y2 + 1, x2 + w2 - dx, y2 + h2 - 1);
            }
        }

        public Insets getBorderInsets(Component c2) {
            if (this.hasLogo(c2)) {
                if (JTattooUtilities.isLeftToRight(c2)) {
                    return new Insets(BasePopupMenuBorder.leftLogoInsets.top, BasePopupMenuBorder.leftLogoInsets.left, BasePopupMenuBorder.leftLogoInsets.bottom + shadowSize, BasePopupMenuBorder.leftLogoInsets.right + shadowSize);
                }
                return new Insets(BasePopupMenuBorder.rightLogoInsets.top, BasePopupMenuBorder.rightLogoInsets.left, BasePopupMenuBorder.rightLogoInsets.bottom + shadowSize, BasePopupMenuBorder.rightLogoInsets.right + shadowSize);
            }
            return new Insets(BasePopupMenuBorder.insets.top, BasePopupMenuBorder.insets.left, BasePopupMenuBorder.insets.bottom + shadowSize, BasePopupMenuBorder.insets.right + shadowSize);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            Insets ins = this.getBorderInsets(c2);
            borderInsets.left = ins.left;
            borderInsets.top = ins.top;
            borderInsets.right = ins.right;
            borderInsets.bottom = ins.bottom;
            return borderInsets;
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);
        private static final Insets tableInsets = new Insets(1, 1, 1, 1);
        private boolean tableBorder = false;

        public ScrollPaneBorder(boolean tableBorder) {
            this.tableBorder = tableBorder;
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            g2.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            g2.drawRect(x2, y2, w2 - 1, h2 - 1);
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getBackgroundColor(), 50.0));
            g2.drawRect(x2 + 1, y2 + 1, w2 - 3, h2 - 3);
        }

        public Insets getBorderInsets(Component c2) {
            if (this.tableBorder) {
                return new Insets(ScrollPaneBorder.tableInsets.top, ScrollPaneBorder.tableInsets.left, ScrollPaneBorder.tableInsets.bottom, ScrollPaneBorder.tableInsets.right);
            }
            return new Insets(ScrollPaneBorder.insets.top, ScrollPaneBorder.insets.left, ScrollPaneBorder.insets.bottom, ScrollPaneBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            Insets ins = this.getBorderInsets(c2);
            borderInsets.left = ins.left;
            borderInsets.top = ins.top;
            borderInsets.right = ins.right;
            borderInsets.bottom = ins.bottom;
            return borderInsets;
        }
    }

    public static class TableHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 0);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            Graphics2D g2D = (Graphics2D)g2;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.8f);
            g2D.setComposite(alpha);
            ColorUIResource cHi = AbstractLookAndFeel.getTheme().getControlHighlightColor();
            ColorUIResource cLo = AbstractLookAndFeel.getTheme().getControlShadowColor();
            JTattooUtilities.draw3DBorder(g2, cHi, cLo, x2, y2, w2, h2);
            g2D.setComposite(savedComposite);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(TableHeaderBorder.insets.top, TableHeaderBorder.insets.left, TableHeaderBorder.insets.bottom, TableHeaderBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = TableHeaderBorder.insets.left;
            borderInsets.top = TableHeaderBorder.insets.top;
            borderInsets.right = TableHeaderBorder.insets.right;
            borderInsets.bottom = TableHeaderBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            g2.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            g2.drawRect(x2, y2, width - 1, height - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(ComboBoxBorder.insets.top, ComboBoxBorder.insets.left, ComboBoxBorder.insets.bottom, ComboBoxBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ComboBoxBorder.insets.left;
            borderInsets.top = ComboBoxBorder.insets.top;
            borderInsets.right = ComboBoxBorder.insets.right;
            borderInsets.bottom = ComboBoxBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class SpinnerBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            g2.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            g2.drawRect(x2, y2, width - 1, height - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(SpinnerBorder.insets.top, SpinnerBorder.insets.left, SpinnerBorder.insets.bottom, SpinnerBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = SpinnerBorder.insets.left;
            borderInsets.top = SpinnerBorder.insets.top;
            borderInsets.right = SpinnerBorder.insets.right;
            borderInsets.bottom = SpinnerBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class TextFieldBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            g2.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            g2.drawRect(x2, y2, width - 1, height - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(TextFieldBorder.insets.top, TextFieldBorder.insets.left, TextFieldBorder.insets.bottom, TextFieldBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = TextFieldBorder.insets.left;
            borderInsets.top = TextFieldBorder.insets.top;
            borderInsets.right = TextFieldBorder.insets.right;
            borderInsets.bottom = TextFieldBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class FocusFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            Color hiColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 60.0);
            ColorUIResource loColor = AbstractLookAndFeel.getTheme().getFocusFrameColor();
            g2.setColor(loColor);
            g2.drawRect(x2, y2, width - 1, height - 1);
            g2.setColor(hiColor);
            g2.drawRect(x2 + 1, y2 + 1, width - 3, height - 3);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(FocusFrameBorder.insets.top, FocusFrameBorder.insets.left, FocusFrameBorder.insets.bottom, FocusFrameBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = FocusFrameBorder.insets.left;
            borderInsets.top = FocusFrameBorder.insets.top;
            borderInsets.right = FocusFrameBorder.insets.right;
            borderInsets.bottom = FocusFrameBorder.insets.bottom;
            return borderInsets;
        }
    }
}

