/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public abstract class AbstractToolBarUI
extends BasicToolBarUI {
    private static final String IS_ROLLOVER = "JToolBar.isRollover";
    private static final Insets BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private static final Border INNER_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private boolean rolloverEnabled = true;
    private MyPropertyChangeListener propertyChangeListener = null;
    private MyContainerListener containerListener = null;
    private Hashtable orgBorders = new Hashtable();
    private Hashtable orgMargins = new Hashtable();

    public abstract Border getRolloverBorder();

    public abstract Border getNonRolloverBorder();

    public abstract boolean isButtonOpaque();

    public void installUI(JComponent c2) {
        super.installUI(c2);
        Boolean isRollover = (Boolean)UIManager.get(IS_ROLLOVER);
        if (isRollover != null) {
            this.rolloverEnabled = isRollover;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractToolBarUI.this.changeBorders();
            }
        });
    }

    public void uninstallUI(JComponent c2) {
        this.restoreBorders();
        super.uninstallUI(c2);
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new MyPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.containerListener = new MyContainerListener();
        if (this.containerListener != null) {
            this.toolBar.addContainerListener(this.containerListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyChangeListener = null;
        if (this.containerListener != null) {
            this.toolBar.removeContainerListener(this.containerListener);
        }
        this.containerListener = null;
        super.uninstallListeners();
    }

    protected boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    protected void setBorderToNormal(Component c2) {
    }

    protected void setBorderToRollover(Component c2) {
    }

    protected void setBorderToNonRollover(Component c2) {
    }

    protected void changeBorders() {
        Component[] components = this.toolBar.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component comp = components[i2];
            if (!(comp instanceof AbstractButton)) continue;
            this.changeButtonBorder((AbstractButton)comp);
        }
    }

    protected void restoreBorders() {
        Component[] components = this.toolBar.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component comp = components[i2];
            if (!(comp instanceof AbstractButton)) continue;
            this.restoreButtonBorder((AbstractButton)comp);
        }
    }

    protected void changeButtonBorder(AbstractButton b2) {
        Boolean changeBorder;
        Object cp = b2.getClientProperty("paintToolBarBorder");
        if (cp != null && cp instanceof Boolean && !(changeBorder = (Boolean)cp).booleanValue()) {
            return;
        }
        if (!this.orgBorders.contains(b2)) {
            if (b2.getBorder() != null) {
                this.orgBorders.put(b2, b2.getBorder());
            } else {
                this.orgBorders.put(b2, new NullBorder());
            }
        }
        if (!this.orgMargins.contains(b2)) {
            this.orgMargins.put(b2, b2.getMargin());
        }
        if (b2.getBorder() != null) {
            if (this.isRolloverEnabled()) {
                b2.setBorderPainted(true);
                b2.setBorder(BorderFactory.createCompoundBorder(this.getRolloverBorder(), INNER_BORDER));
                b2.setMargin(BUTTON_MARGIN);
                b2.setRolloverEnabled(true);
                b2.setOpaque(this.isButtonOpaque());
                b2.setContentAreaFilled(this.isButtonOpaque());
            } else {
                b2.setBorder(BorderFactory.createCompoundBorder(this.getNonRolloverBorder(), INNER_BORDER));
                b2.setMargin(BUTTON_MARGIN);
                b2.setRolloverEnabled(false);
                b2.setOpaque(this.isButtonOpaque());
                b2.setContentAreaFilled(this.isButtonOpaque());
            }
        }
    }

    protected void restoreButtonBorder(AbstractButton b2) {
        Boolean changeBorder;
        Object cp = b2.getClientProperty("paintToolBarBorder");
        if (cp != null && cp instanceof Boolean && !(changeBorder = (Boolean)cp).booleanValue()) {
            return;
        }
        Border border = (Border)this.orgBorders.get(b2);
        if (border != null) {
            if (border instanceof NullBorder) {
                b2.setBorder(null);
            } else {
                b2.setBorder(border);
            }
        }
        b2.setMargin((Insets)this.orgMargins.get(b2));
    }

    protected void updateToolbarBorder() {
        this.toolBar.revalidate();
        this.toolBar.repaint();
    }

    protected boolean isToolBarUnderMenubar() {
        JRootPane rp;
        JMenuBar mb;
        if (this.toolBar != null && this.toolBar.getOrientation() == 0 && (mb = (rp = SwingUtilities.getRootPane(this.toolBar)).getJMenuBar()) != null) {
            Point mbPoint = new Point(0, 0);
            mbPoint = SwingUtilities.convertPoint(mb, mbPoint, rp);
            Point tbPoint = new Point(0, 0);
            tbPoint = SwingUtilities.convertPoint(this.toolBar, tbPoint, rp);
            tbPoint.y -= mb.getHeight() - 1;
            Rectangle rect = new Rectangle(mbPoint, mb.getSize());
            return rect.contains(tbPoint);
        }
        return false;
    }

    protected boolean isToolbarDecorated() {
        return AbstractLookAndFeel.getTheme().isToolbarDecorated();
    }

    private static class NullBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(0, 0, 0, 0);

        private NullBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
        }

        public Insets getBorderInsets(Component c2) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    protected class MyContainerListener
    implements ContainerListener {
        protected MyContainerListener() {
        }

        public void componentAdded(ContainerEvent e2) {
            Component c2 = e2.getChild();
            if (c2 instanceof AbstractButton) {
                AbstractToolBarUI.this.changeButtonBorder((AbstractButton)c2);
            }
        }

        public void componentRemoved(ContainerEvent e2) {
            Component c2 = e2.getChild();
            if (c2 instanceof AbstractButton) {
                AbstractToolBarUI.this.restoreButtonBorder((AbstractButton)c2);
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e2) {
            if (e2.getPropertyName().equals(AbstractToolBarUI.IS_ROLLOVER)) {
                if (e2.getNewValue() != null) {
                    AbstractToolBarUI.this.rolloverEnabled = (Boolean)e2.getNewValue();
                    AbstractToolBarUI.this.changeBorders();
                }
            } else if ("componentOrientation".equals(e2.getPropertyName())) {
                AbstractToolBarUI.this.updateToolbarBorder();
            }
        }
    }
}

